/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import snownee.kiwi.recipe.crafting.KiwiShapelessRecipe;

public class KiwiShapelessRecipeBuilder
extends ShapelessRecipeBuilder {
    private boolean noContainers;

    public KiwiShapelessRecipeBuilder(RecipeCategory category, ItemLike result, int count) {
        super(category, result, count);
    }

    public static KiwiShapelessRecipeBuilder shapeless(RecipeCategory category, ItemLike result) {
        return new KiwiShapelessRecipeBuilder(category, result, 1);
    }

    public static KiwiShapelessRecipeBuilder shapeless(RecipeCategory category, ItemLike result, int count) {
        return new KiwiShapelessRecipeBuilder(category, result, count);
    }

    public KiwiShapelessRecipeBuilder noContainers() {
        this.noContainers = true;
        return this;
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        this.ensureValid(resourceLocation);
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)resourceLocation)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)resourceLocation)).requirements(AdvancementRequirements.Strategy.OR);
        Objects.requireNonNull(builder);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        KiwiShapelessRecipe shapelessRecipe = new KiwiShapelessRecipe(Objects.requireNonNullElse(this.group, ""), RecipeBuilder.determineBookCategory((RecipeCategory)this.category), new ItemStack((ItemLike)this.result, this.count), (NonNullList<Ingredient>)this.ingredients, this.noContainers);
        recipeOutput.accept(resourceLocation, (Recipe)shapelessRecipe, builder.build(resourceLocation.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }
}

