/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.GameObjectLookup;
import snownee.kiwi.util.KUtil;

public class KiwiLanguageProvider
extends FabricLanguageProvider {
    protected final String languageCode;
    protected final CompletableFuture<HolderLookup.Provider> registryLookup;

    public KiwiLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
        this(dataOutput, "en_us", registryLookup);
    }

    public KiwiLanguageProvider(FabricDataOutput dataOutput, String languageCode, CompletableFuture<HolderLookup.Provider> registryLookup) {
        super(dataOutput, languageCode, registryLookup);
        this.languageCode = languageCode;
        this.registryLookup = registryLookup;
    }

    public void generateTranslations(HolderLookup.Provider registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
    }

    public Optional<Path> createPath(String path, String extension) {
        String modId = this.dataOutput.getModId();
        return Platform.findResource(modId, "assets/%s/lang/%s.%s".formatted(modId, path, extension));
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.putExistingTranslations(translationBuilder, this.languageCode + ".existing");
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, String path) {
        try {
            Path existingFilePath = this.createPath(path, "json").orElseThrow();
            translationBuilder.add(existingFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public void putExistingYamlTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.putExistingYamlTranslations(translationBuilder, this.languageCode + ".existing");
    }

    public void putExistingYamlTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, String path) {
        try {
            Path existingFilePath = this.createPath(path, "yaml").orElseThrow();
            try (BufferedReader reader = Files.newBufferedReader(existingFilePath);){
                Map map = KUtil.loadYaml(reader, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    translationBuilder.add((String)entry.getKey(), entry.getValue().toString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public CompletableFuture<?> run(CachedOutput writer) {
        TreeMap translationEntries = new TreeMap();
        return this.registryLookup.thenCompose(lookup -> {
            this.preGenerate(translationEntries);
            this.generateModNameAndDescription(translationEntries);
            this.generateConfigEntries(translationEntries);
            this.generateTranslations((HolderLookup.Provider)lookup, (key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                if (translationEntries.containsKey(key)) {
                    throw new RuntimeException("Existing translation key found - " + key + " - Duplicate will be ignored.");
                }
                translationEntries.put(key, value);
            });
            FabricLanguageProvider.TranslationBuilder translationBuilder = (key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                translationEntries.put(key, value);
            };
            if (this.createPath("en_us.existing", "yaml").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false).booleanValue()) {
                this.putExistingYamlTranslations(translationBuilder);
            } else if (this.createPath("en_us.existing", "json").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false).booleanValue()) {
                this.putExistingTranslations(translationBuilder);
            }
            this.postGenerate(translationEntries);
            JsonObject langEntryJson = new JsonObject();
            for (Map.Entry entry : translationEntries.entrySet()) {
                langEntryJson.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return DataProvider.saveStable((CachedOutput)writer, (JsonElement)langEntryJson, (Path)this.getLangFilePath(this.languageCode));
        });
    }

    protected void postGenerate(TreeMap<String, String> translationEntries) {
    }

    protected void preGenerate(TreeMap<String, String> translationEntries) {
    }

    protected void generateConfigEntries(Map<String, String> translationEntries) {
        for (ConfigHandler handler : KiwiConfigManager.allConfigs) {
            String fileName;
            if (!Objects.equals(handler.getModId(), this.dataOutput.getModId()) || (fileName = handler.getFileName()).equals("test") || fileName.equals("kiwi-modules") || handler.getClazz() != null && handler.getClazz().getDeclaredAnnotation(KiwiModule.Skip.class) != null) continue;
            String key = handler.getTranslationKey();
            if (Objects.equals(key, fileName)) {
                translationEntries.put("kiwi.config." + key, KUtil.friendlyText(key));
            }
            HashSet subCats = Sets.newHashSet();
            for (ConfigHandler.Value<?> value : handler.getValueMap().values()) {
                ConfigUI.Hide hide;
                if (value.path.startsWith("modules.test") || (hide = value.getAnnotation(ConfigUI.Hide.class)) != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String title = KUtil.friendlyText((String)path.removeLast());
                String subCatKey = String.join((CharSequence)".", path);
                if (!path.isEmpty() && !subCats.contains(subCatKey)) {
                    subCats.add(subCatKey);
                    translationEntries.put(handler.getModId() + ".config." + subCatKey, KUtil.friendlyText((String)path.getLast()));
                }
                translationEntries.put(value.translation, title);
                translationEntries.put(value.translation + ".desc", "");
            }
        }
    }

    protected void generateGameObjectsEntries(Map<String, String> translationEntries) {
        this.generateGameObjectEntries(translationEntries, Registries.BLOCK, Block::getDescriptionId);
        this.generateGameObjectEntries(translationEntries, Registries.ITEM, Item::getDescriptionId);
        this.generateGameObjectEntries(translationEntries, Registries.ENTITY_TYPE, EntityType::getDescriptionId);
        this.generateGameObjectEntries(translationEntries, Registries.CREATIVE_MODE_TAB, tab -> {
            Component component = tab.getDisplayName();
            ComponentContents patt0$temp = component.getContents();
            if (patt0$temp instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)patt0$temp;
                return contents.getKey();
            }
            return null;
        });
        this.generateGameObjectEntries(translationEntries, Registries.CUSTOM_STAT, stat -> Util.makeDescriptionId((String)"stat", (ResourceLocation)stat));
        this.generateGameObjectEntries(translationEntries, Registries.MOB_EFFECT, MobEffect::getDescriptionId);
    }

    protected void generateModNameAndDescription(Map<String, String> translationEntries) {
        String modId = this.dataOutput.getModId();
        translationEntries.put("modmenu.nameTranslation.%s".formatted(modId), Platform.getModName(modId));
        translationEntries.put("modmenu.descriptionTranslation.%s".formatted(modId), Platform.getModDescription(modId));
    }

    protected <T> void generateGameObjectEntries(Map<String, String> translationEntries, ResourceKey<Registry<T>> registryKey, Function<T, String> keyMapper) {
        GameObjectLookup.allHolders(registryKey, this.dataOutput.getModId()).forEach(holder -> {
            String key = (String)keyMapper.apply(holder.value());
            if (key != null) {
                translationEntries.put(key, KUtil.friendlyText(holder.key().location().getPath()));
            }
        });
    }

    private Path getLangFilePath(String code) {
        return this.dataOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "lang").json(ResourceLocation.fromNamespaceAndPath((String)this.dataOutput.getModId(), (String)code));
    }
}

