/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.customization.builder.BuilderRules;
import snownee.kiwi.customization.builder.BuildersButton;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.KUtil;

public class BuilderModePreview
implements DebugRenderer.SimpleDebugRenderer {
    public KHolder<BuilderRule> rule;
    public BlockPos pos;
    private BlockState blockState = Blocks.AIR.defaultBlockState();
    public List<BlockPos> positions = List.of();
    private final ListMultimap<Direction, AABB> faces = ArrayListMultimap.create((int)6, (int)32);
    private long lastUpdateTime;

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, double pCamX, double pCamY, double pCamZ) {
        BlockHitResult hitResult;
        Minecraft mc;
        block8: {
            block7: {
                HitResult hitResult2;
                mc = Minecraft.getInstance();
                if (!BuildersButton.isBuilderModeOn() || !((hitResult2 = mc.hitResult) instanceof BlockHitResult)) break block7;
                hitResult = (BlockHitResult)hitResult2;
                if (mc.hitResult.getType() != HitResult.Type.MISS) break block8;
            }
            this.positions = List.of();
            return;
        }
        long millis = Util.getMillis();
        Player player = (Player)Objects.requireNonNull(mc.player);
        BlockState blockState = player.level().getBlockState(hitResult.getBlockPos());
        if (millis - this.lastUpdateTime > 200L || !hitResult.getBlockPos().equals((Object)this.pos) || this.blockState != blockState) {
            this.lastUpdateTime = millis;
            this.blockState = blockState;
            this.updatePositions(player, hitResult);
        }
        if (this.positions.isEmpty()) {
            return;
        }
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.debugQuads());
        Matrix4f pose = pPoseStack.last().pose();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 0.08f + Mth.sin((float)((float)millis / 350.0f)) * 0.05f;
        for (Map.Entry entry : this.faces.asMap().entrySet()) {
            Direction direction = (Direction)entry.getKey();
            for (AABB aabb : (Collection)entry.getValue()) {
                aabb = aabb.move(-pCamX, -pCamY, -pCamZ);
                this.drawFace(pose, vertexconsumer, aabb, direction, r, g, b, a);
            }
        }
    }

    private void updatePositions(Player player, BlockHitResult hitResult) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack itemStack = player.getItemInHand(hand);
        this.rule = null;
        this.pos = null;
        this.positions = List.of();
        for (KHolder<BuilderRule> holder : BuilderRules.find(this.blockState.getBlock())) {
            if (!holder.value().matches(player, itemStack, this.blockState)) continue;
            this.positions = holder.value().searchPositions(this.blockState, new UseOnContext(player, hand, hitResult));
            if (this.positions.isEmpty()) continue;
            this.rule = holder;
            this.pos = hitResult.getBlockPos();
            this.faces.clear();
            VoxelShape fullShape = this.positions.stream().map(BuilderModePreview::getShape).reduce(Shapes.empty(), (a, b) -> Shapes.joinUnoptimized((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.OR));
            fullShape = fullShape.optimize();
            List aabbs = fullShape.toAabbs();
            for (Direction direction : KUtil.DIRECTIONS) {
                for (AABB aabb : aabbs) {
                    VoxelShape faceShape = BuilderModePreview.getFaceShape(aabb, direction);
                    if ((faceShape = Shapes.join((VoxelShape)faceShape, (VoxelShape)fullShape, (BooleanOp)BooleanOp.ONLY_FIRST)).isEmpty()) continue;
                    for (AABB faceShapeAabb : faceShape.toAabbs()) {
                        this.faces.put((Object)direction, (Object)faceShapeAabb);
                    }
                }
            }
        }
    }

    private void drawFace(Matrix4f pose, VertexConsumer consumer, AABB aabb, Direction face, float r, float g, float b, float a) {
        float minX = (float)aabb.minX;
        float minY = (float)aabb.minY;
        float minZ = (float)aabb.minZ;
        float maxX = (float)aabb.maxX;
        float maxY = (float)aabb.maxY;
        float maxZ = (float)aabb.maxZ;
        switch (face) {
            case DOWN: {
                consumer.addVertex(pose, minX, minY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, minX, minY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, minY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, minY, minZ).setColor(r, g, b, a);
                break;
            }
            case UP: {
                consumer.addVertex(pose, minX, maxY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, maxY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, maxY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, minX, maxY, maxZ).setColor(r, g, b, a);
                break;
            }
            case NORTH: {
                consumer.addVertex(pose, minX, minY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, minY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, maxY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, minX, maxY, minZ).setColor(r, g, b, a);
                break;
            }
            case SOUTH: {
                consumer.addVertex(pose, minX, minY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, minX, maxY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, maxY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, minY, maxZ).setColor(r, g, b, a);
                break;
            }
            case WEST: {
                consumer.addVertex(pose, minX, minY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, minX, minY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, minX, maxY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, minX, maxY, minZ).setColor(r, g, b, a);
                break;
            }
            case EAST: {
                consumer.addVertex(pose, maxX, minY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, maxY, minZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, maxY, maxZ).setColor(r, g, b, a);
                consumer.addVertex(pose, maxX, minY, maxZ).setColor(r, g, b, a);
            }
        }
    }

    private static VoxelShape getFaceShape(AABB aabb, Direction face) {
        aabb = switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new AABB(aabb.minX, aabb.minY - 1.0E-4, aabb.minZ, aabb.maxX, aabb.minY, aabb.maxZ);
            case Direction.UP -> new AABB(aabb.minX, aabb.maxY, aabb.minZ, aabb.maxX, aabb.maxY + 1.0E-4, aabb.maxZ);
            case Direction.NORTH -> new AABB(aabb.minX, aabb.minY, aabb.minZ - 1.0E-4, aabb.maxX, aabb.maxY, aabb.minZ);
            case Direction.SOUTH -> new AABB(aabb.minX, aabb.minY, aabb.maxZ, aabb.maxX, aabb.maxY, aabb.maxZ + 1.0E-4);
            case Direction.WEST -> new AABB(aabb.minX - 1.0E-4, aabb.minY, aabb.minZ, aabb.minX, aabb.maxY, aabb.maxZ);
            case Direction.EAST -> new AABB(aabb.maxX, aabb.minY, aabb.minZ, aabb.maxX + 1.0E-4, aabb.maxY, aabb.maxZ);
        };
        return Shapes.create((AABB)aabb);
    }

    private static VoxelShape getShape(BlockPos pos) {
        ClientLevel level = Objects.requireNonNull(Minecraft.getInstance().level);
        BlockState blockState = level.getBlockState(pos);
        return blockState.getShape((BlockGetter)level, pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }
}

