/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.apache.commons.lang3.NotImplementedException;
import snownee.kiwi.customization.block.BasicBlock;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.customization.duck.KBlockProperties;
import snownee.kiwi.util.codec.CustomizationCodecs;

public class BlockCodecs {
    private static final Map<ResourceLocation, MapCodec<Block>> CODECS = Maps.newHashMap();
    public static final String BLOCK_PROPERTIES_KEY = "properties";
    public static final Function<BlockBehaviour.Properties, Block> SIMPLE_BLOCK_FACTORY = properties -> {
        KBlockSettings settings = ((KBlockProperties)properties).kiwi$getSettings();
        if (settings != null && settings.hasComponent(KBlockComponents.WATER_LOGGABLE.getOrCreate())) {
            return new BasicBlock((BlockBehaviour.Properties)properties);
        }
        return new Block(properties);
    };
    public static final MapCodec<Block> BLOCK = Block.simpleCodec(SIMPLE_BLOCK_FACTORY);
    public static final MapCodec<StairBlock> STAIR = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.optionalFieldOf("base_state", (Object)Blocks.AIR.defaultBlockState()).forGetter(block -> {
        throw new UnsupportedOperationException();
    }), (App)Block.propertiesCodec()).apply((Applicative)instance, StairBlock::new));
    public static final MapCodec<FenceGateBlock> FENCE_GATE = BlockCodecs.woodTyped(FenceGateBlock::new);
    public static final MapCodec<ColoredFallingBlock> COLORED_FALLING = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ColorRGBA.CODEC.optionalFieldOf("falling_dust_color", (Object)new ColorRGBA(14406560)).forGetter($ -> new ColorRGBA(14406560)), (App)Block.propertiesCodec()).apply((Applicative)instance, ColoredFallingBlock::new));
    public static final MapCodec<ButtonBlock> BUTTON = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(BlockCodecs::notImplemented), (App)Codec.intRange((int)1, (int)1024).optionalFieldOf("ticks_to_stay_pressed").forGetter(BlockCodecs::notImplemented), (App)Block.propertiesCodec()).apply((Applicative)instance, (blockSetType, ticksToStayPressed, properties) -> new ButtonBlock(blockSetType, ticksToStayPressed.orElse(blockSetType.canOpenByHand() ? 30 : 20).intValue(), properties)));
    public static final MapCodec<WallSignBlock> WALL_SIGN = BlockCodecs.woodTyped(WallSignBlock::new);
    public static final MapCodec<StandingSignBlock> STANDING_SIGN = BlockCodecs.woodTyped(StandingSignBlock::new);
    public static final MapCodec<WallHangingSignBlock> WALL_HANGING_SIGN = BlockCodecs.woodTyped(WallHangingSignBlock::new);
    public static final MapCodec<CeilingHangingSignBlock> CEILING_HANGING_SIGN = BlockCodecs.woodTyped(CeilingHangingSignBlock::new);
    public static final MapCodec<SaplingBlock> SAPLING = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.TREE_GROWER.fieldOf("tree").forGetter(BlockCodecs::notImplemented), (App)Block.propertiesCodec()).apply((Applicative)instance, SaplingBlock::new));

    public static void register(String key, MapCodec<? extends Block> codec) {
        BlockCodecs.register(ResourceLocation.withDefaultNamespace((String)key), codec);
    }

    public static void register(ResourceLocation key, MapCodec<? extends Block> codec) {
        CODECS.put(key, codec);
    }

    public static MapCodec<Block> get(ResourceLocation key) {
        MapCodec<Block> codec = CODECS.get(key);
        if (codec != null) {
            return codec;
        }
        return (MapCodec)BuiltInRegistries.BLOCK_TYPE.get(key);
    }

    public static <O, A> A notImplemented(O block) {
        throw new NotImplementedException();
    }

    public static <T extends Block> MapCodec<T> woodTyped(BiFunction<WoodType, BlockBehaviour.Properties, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)WoodType.CODEC.optionalFieldOf("wood_type", (Object)WoodType.OAK).forGetter($ -> WoodType.OAK), (App)Block.propertiesCodec()).apply((Applicative)instance, factory));
    }

    static {
        BlockCodecs.register("block", BLOCK);
        BlockCodecs.register("stair", STAIR);
        BlockCodecs.register("fence_gate", FENCE_GATE);
        BlockCodecs.register("colored_falling", COLORED_FALLING);
        BlockCodecs.register("button", BUTTON);
        BlockCodecs.register("wall_sign", WALL_SIGN);
        BlockCodecs.register("standing_sign", STANDING_SIGN);
        BlockCodecs.register("wall_hanging_sign", WALL_HANGING_SIGN);
        BlockCodecs.register("ceiling_hanging_sign", CEILING_HANGING_SIGN);
        BlockCodecs.register("sapling", SAPLING);
    }
}

