/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.processing.enchanter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.advancements.AdvancementBehaviour;
import plus.dragons.createdragonsplus.common.fluids.tank.ConfigurableFluidTank;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;
import plus.dragons.createenchantmentindustry.client.model.CEIPartialModels;
import plus.dragons.createenchantmentindustry.common.fluids.experience.BlazeExperienceBlockEntity;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.EnchanterBehaviour;
import plus.dragons.createenchantmentindustry.common.processing.enchanter.EnchantingTemplateItem;
import plus.dragons.createenchantmentindustry.common.registry.CEIAdvancements;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.common.registry.CEIStats;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

@FieldsNullabilityUnknownByDefault
public class BlazeEnchanterBlockEntity
extends BlazeExperienceBlockEntity {
    public static final int ENCHANTING_TIME = 200;
    protected EnchanterBehaviour enchanter;
    protected boolean special;
    protected boolean cursed;
    protected Long seed;
    protected int processingTime = -1;
    protected ItemStack heldItem = ItemStack.EMPTY;
    protected AdvancementBehaviour advancement;

    public BlazeEnchanterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        if (!(side != Direction.DOWN && side != null || this.isRemoved())) {
            return this.tanks.getCapability();
        }
        return null;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.enchanter = new EnchanterBehaviour(this, (ValueBoxTransform)new EnchanterTransform(), new TemplateItemTransform());
        this.advancement = new AdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.enchanter);
        behaviours.add((BlockEntityBehaviour)this.advancement);
    }

    @Override
    protected ConfigurableFluidTank createNormalTank(Consumer<FluidStack> fluidUpdateCallback) {
        return new ConfigurableFluidTank(((Integer)CEIConfig.fluids().blazeEnchanterFluidCapacity.get()).intValue(), fluidUpdateCallback).allowInsertion(fluidStack -> fluidStack.is(CEIFluids.EXPERIENCE));
    }

    @Override
    protected ConfigurableFluidTank createSpecialTank(Consumer<FluidStack> fluidUpdateCallback) {
        return new ConfigurableFluidTank(((Integer)CEIConfig.fluids().blazeEnchanterFluidCapacity.get()).intValue(), fluidUpdateCallback).forbidInsertion();
    }

    public boolean isActive() {
        return this.processingTime > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected PartialModel getHatModel(BlazeBurnerBlock.HeatLevel heatLevel) {
        return heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? CEIPartialModels.BLAZE_ENCHANTER_HAT : CEIPartialModels.BLAZE_ENCHANTER_HAT_SMALL;
    }

    public void initialize() {
        super.initialize();
        if (this.seed == null) {
            this.nextSeed();
            this.setChanged();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.level != null) {
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)this.heldItem);
        }
    }

    @Override
    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.seed != null) {
            compound.putLong("Seed", this.seed.longValue());
        }
        compound.putInt("ProcessingTime", this.processingTime);
        compound.put("HeldItem", this.heldItem.saveOptional(registries));
        super.write(compound, registries, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (compound.contains("Seed", 4)) {
            this.seed = compound.getLong("Seed");
        }
        this.processingTime = compound.getInt("ProcessingTime");
        this.heldItem = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("HeldItem"));
        super.read(compound, registries, clientPacket);
    }

    public void tick() {
        Level level;
        boolean cursed;
        boolean special;
        super.tick();
        boolean update = false;
        boolean bl = special = this.getHeatLevelFromBlock() == BlazeBurnerBlock.HeatLevel.SEETHING;
        if (this.special != special) {
            this.special = special;
            update = true;
        }
        BlockPos strikePos = this.getStrikePos();
        boolean bl2 = cursed = special && !this.worldPosition.equals((Object)strikePos);
        if (this.cursed != cursed) {
            this.cursed = cursed;
            update = true;
        }
        if (this.level.isClientSide() && this.isVirtual()) {
            if (update) {
                this.enchanter.update(this.heldItem);
            }
            if (this.enchanter.canProcess(this.heldItem)) {
                if (this.processingTime < 0) {
                    this.processingTime = 50;
                    return;
                }
                if (this.processingTime > 0) {
                    --this.processingTime;
                    return;
                }
                this.processingTime = -1;
                this.heldItem = this.enchanter.getResult(this.heldItem);
                return;
            }
        }
        if (!((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (update) {
            this.enchanter.update(this.heldItem);
        }
        if (this.enchanter.canProcess(this.heldItem)) {
            int cost = this.enchanter.getExperienceCost();
            if (cost > 0 && this.consumeExperience(cost, special, true)) {
                if (this.processingTime < 0) {
                    this.processingTime = 200;
                    this.notifyUpdate();
                    return;
                }
                if (this.processingTime > 0) {
                    --this.processingTime;
                    this.notifyUpdate();
                    return;
                }
                if (special && !cursed && this.strikeLightning(serverLevel, strikePos)) {
                    this.advancement.trigger(CEIAdvancements.OSHA_VIOLATION.builtinTrigger());
                    serverLevel.destroyBlock(this.worldPosition, false);
                    serverLevel.setBlockAndUpdate(this.worldPosition, AllBlocks.LIT_BLAZE_BURNER.getDefaultState());
                    this.setRemoved();
                    return;
                }
                this.processingTime = -1;
                this.heldItem = this.enchanter.getResult(this.heldItem);
                this.advancement.awardStat((ResourceLocation)CEIStats.ENCHANT.get(), 1);
                if (this.heldItem.getItem() instanceof EnchantingTemplateItem) {
                    this.advancement.trigger(CEIAdvancements.SIGIL_FORGING.builtinTrigger());
                } else {
                    this.advancement.trigger(CEIAdvancements.BLAZING_ENCHANTMENT.builtinTrigger());
                }
                if (special) {
                    this.advancement.awardStat((ResourceLocation)CEIStats.SUPER_ENCHANT.get(), 1);
                    boolean treasure = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)this.heldItem).keySet().stream().anyMatch(h -> h.is(EnchantmentTags.TREASURE));
                    if (treasure) {
                        this.advancement.trigger(CEIAdvancements.PROBABILITY_SPIKE.builtinTrigger());
                    }
                }
                this.consumeExperience(cost, special, false);
                this.nextSeed();
                this.notifyUpdate();
                this.level.playSound(null, this.worldPosition, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f);
            } else if (this.processingTime != -1) {
                this.processingTime = -1;
                this.notifyUpdate();
            }
        } else if (this.processingTime != -1) {
            this.processingTime = -1;
            this.notifyUpdate();
        }
    }

    public RandomSource getRandom() {
        return RandomSource.create((long)this.seed);
    }

    public void nextSeed() {
        assert (this.level != null);
        this.seed = this.level.random.nextLong();
    }

    public int getMaxEnchantLevel() {
        return this.getMaxEnchantLevel(this.getHeatLevel() == BlazeBurnerBlock.HeatLevel.SEETHING);
    }

    public int getMaxEnchantLevel(boolean special) {
        int max = (Integer)CEIConfig.enchantments().blazeEnchanterMaxEnchantLevel.get();
        int maxSuper = (Integer)CEIConfig.enchantments().blazeEnchanterMaxSuperEnchantLevel.get();
        return special ? Math.max(max, maxSuper) : Math.clamp((long)max, 0, maxSuper);
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        assert (this.level != null);
        if (!this.heldItem.isEmpty()) {
            return stack;
        }
        ItemStack input = stack.copy();
        ItemStack inserted = input.split(1);
        this.enchanter.update(inserted);
        if (!this.enchanter.canProcess(inserted)) {
            this.enchanter.update(ItemStack.EMPTY);
            return stack;
        }
        if (simulate) {
            return input;
        }
        this.heldItem = inserted;
        this.notifyUpdate();
        return input;
    }

    public ItemStack extractItem(boolean forced, boolean simulate) {
        assert (this.level != null);
        ItemStack extracted = ItemStack.EMPTY;
        if (forced || this.processingTime <= 0) {
            extracted = this.heldItem.copy();
            if (!simulate) {
                this.heldItem = ItemStack.EMPTY;
                this.processingTime = -1;
                this.notifyUpdate();
            }
        }
        return extracted;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return added |= this.enchanter.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    private static class EnchanterTransform
    extends ValueBoxTransform.Sided {
        private EnchanterTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)13.5);
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack poseStack) {
            float yRot = AngleHelper.horizontalAngle((Direction)this.getSide()) + 180.0f;
            TransformStack.of((PoseStack)poseStack).rotateYDegrees(yRot);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.getAxis().isHorizontal();
        }
    }

    private static class TemplateItemTransform
    extends ValueBoxTransform.Sided {
        private TemplateItemTransform() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)14.5);
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack poseStack) {
            float yRot = AngleHelper.horizontalAngle((Direction)this.getSide()) + 180.0f;
            TransformStack.of((PoseStack)poseStack).rotateYDegrees(yRot);
        }

        public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
            if (!this.isSideActive(state, this.getSide())) {
                return false;
            }
            Vec3 location = VecHelper.voxelSpace((double)8.0, (double)8.0, (double)13.5);
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            return localHit.distanceTo(location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.verticalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.X)) < (double)this.scale * 1.2;
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.getAxis().isHorizontal();
        }
    }
}

