/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import codechicken.lib.world.IChunkLoadTile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mrtjp.projectred.core.CoreNetwork;
import mrtjp.projectred.core.tile.IPacketReceiverBlockEntity;
import mrtjp.projectred.core.tile.ProjectRedBlockEntity;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.block.ICWorkbenchBlock;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.IICWorkbenchEditorNetwork;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;

public class ICWorkbenchBlockEntity
extends ProjectRedBlockEntity
implements IPacketReceiverBlockEntity,
IICWorkbenchEditorNetwork,
IChunkLoadTile {
    private static final int KEY_CLIENT_OPENED_SCREEN = 0;
    private static final int KEY_CLIENT_CLOSED_SCREEN = 1;
    private static final int KEY_EDITOR_DESCRIPTION_UPDATE = 50;
    private static final int KEY_EDITOR_PACKET = 100;
    private final ICWorkbenchEditor editor = new ICWorkbenchEditor(this);
    private final Map<Integer, PacketCustom> editorBufferedStreams = new HashMap<Integer, PacketCustom>();
    private final Set<ServerPlayer> playersWatchingScreen = new HashSet<ServerPlayer>();

    public ICWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super(FabricationBlocks.IC_WORKBENCH_BLOCK_ENTITY.get(), pos, state);
    }

    public ICWorkbenchEditor getEditor() {
        return this.editor;
    }

    public void writeDesc(MCDataOutput out) {
        this.editor.writeDesc(out);
    }

    public void readDesc(MCDataInput in) {
        this.editor.readDesc(in);
    }

    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.editor.save(tag);
    }

    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.editor.load(tag);
    }

    private Set<ServerPlayer> filterAndGetWatchers() {
        Set toRemove = this.playersWatchingScreen.stream().filter(ServerPlayer::hasDisconnected).collect(Collectors.toSet());
        this.playersWatchingScreen.removeAll(toRemove);
        return this.playersWatchingScreen;
    }

    public void tick() {
        this.editor.tick();
        this.flushEditorStreams();
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.getLevel().isClientSide()) {
            boolean blueprintInHand;
            ItemStack stackInHand = player.getItemInHand(hand);
            boolean blueprintOnTable = (Boolean)this.getBlockState().getValue((Property)ICWorkbenchBlock.BLUEPRINT_PROPERTY);
            boolean bl = blueprintInHand = !stackInHand.isEmpty() && stackInHand.getItem() == FabricationItems.IC_BLUEPRINT_ITEM.get();
            if (!blueprintOnTable && blueprintInHand) {
                this.editor.readBlueprintTagAndActivate(stackInHand);
                stackInHand.shrink(1);
                this.setBlueprintBlockState(true);
                this.sendEditorDescription();
            } else if (blueprintOnTable && player.isCrouching()) {
                ItemStack blueprintToDrop = this.createBlueprintStack();
                this.dropBlueprintStack(blueprintToDrop);
                this.setBlueprintBlockState(false);
                this.sendEditorDescription();
            } else {
                this.openGuiFromServer(player);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.getLevel().isClientSide);
    }

    public void onBlockRemoved() {
        if (this.getEditor().isActive()) {
            ItemStack blueprintToDrop = this.createBlueprintStack();
            ProjectRedBlockEntity.dropItem((ItemStack)blueprintToDrop, (Level)this.getLevel(), (Vector3)Vector3.fromBlockPos((BlockPos)this.getBlockPos()));
        }
    }

    private ItemStack createBlueprintStack() {
        ItemStack stack = new ItemStack((ItemLike)FabricationItems.IC_BLUEPRINT_ITEM.get());
        this.editor.writeBlueprintTagAndDeactivate(stack);
        return stack;
    }

    private void dropBlueprintStack(ItemStack blueprintToDrop) {
        BlockPos pos = this.getBlockPos().offset(0, 1, 0);
        ItemEntity itemEntity = new ItemEntity(this.getLevel(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, blueprintToDrop);
        itemEntity.setPickUpDelay(10);
        itemEntity.setDeltaMovement(0.0, 0.15, 0.0);
        this.getLevel().addFreshEntity((Entity)itemEntity);
    }

    private void setBlueprintBlockState(boolean blueprintOnTable) {
        BlockState newState = (BlockState)this.getBlockState().setValue((Property)ICWorkbenchBlock.BLUEPRINT_PROPERTY, (Comparable)Boolean.valueOf(blueprintOnTable));
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), newState);
    }

    private void openGuiFromServer(Player player) {
        if (this.getLevel().isClientSide || !(player instanceof ServerPlayer)) {
            throw new RuntimeException("Server only");
        }
        this.filterAndGetWatchers().add((ServerPlayer)player);
        this.sendUpdateToPlayer(0, this.editor::writeDesc, (ServerPlayer)player);
    }

    private void sendEditorDescription() {
        this.sendUpdateToPlayerList(50, this.editor::writeDesc, this.playersWatchingScreen);
    }

    public void closeGuiFromClient() {
        this.sendUpdateToServer(1, n -> {});
    }

    public void receiveUpdateFromServer(int key, MCDataInput input) {
        switch (key) {
            case 0: {
                this.editor.readDesc(input);
                ICWorkbenchScreen.openGuiOnClient(this);
                break;
            }
            case 50: {
                this.editor.readDesc(input);
                break;
            }
            case 100: {
                this.receiveBufferedStream(input);
                break;
            }
            default: {
                ProjectRedFabrication.LOGGER.error("Unknown packet key from server: " + key);
            }
        }
    }

    public void receiveUpdateFromClient(int key, MCDataInput input, ServerPlayer player) {
        switch (key) {
            case 1: {
                this.filterAndGetWatchers().remove(player);
                break;
            }
            case 100: {
                this.receiveBufferedStream(input);
                break;
            }
            default: {
                ProjectRedFabrication.LOGGER.error("Unknown packet key from client: " + key);
            }
        }
    }

    private void receiveBufferedStream(MCDataInput in) {
        short streamKey = in.readUByte();
        short frameKey = in.readUByte();
        while (frameKey != 255) {
            this.editor.readBufferedStream(in, streamKey, frameKey);
            frameKey = in.readUByte();
        }
    }

    public void onChunkLoad(LevelChunk chunk) {
        this.editor.onChunkLoad();
    }

    @Override
    public MCDataOutput getBufferedStream(int streamKey, int frameKey) {
        MCDataOutput out = (MCDataOutput)this.editorBufferedStreams.computeIfAbsent(streamKey, k -> {
            PacketCustom packet = this.getLevel().isClientSide ? CoreNetwork.createTileServerPacket((IPacketReceiverBlockEntity)this, (byte)100, (RegistryAccess)this.getLevel().registryAccess()) : CoreNetwork.createTileClientPacket((IPacketReceiverBlockEntity)this, (byte)100, (RegistryAccess)this.getLevel().registryAccess());
            packet.writeByte(k.intValue());
            return packet;
        });
        return out.writeByte(frameKey);
    }

    private void flushEditorStreams() {
        for (PacketCustom packet : this.editorBufferedStreams.values()) {
            packet.writeByte(255);
            if (this.getLevel().isClientSide) {
                packet.sendToServer();
                continue;
            }
            for (ServerPlayer player : this.filterAndGetWatchers()) {
                packet.sendToPlayer(player);
            }
        }
        this.editorBufferedStreams.clear();
    }

    @Override
    public boolean isClientSide() {
        return this.getLevel().isClientSide();
    }

    @Override
    public void markSave() {
        this.setChanged();
    }

    @Override
    public long getGameTime() {
        return this.getLevel().getGameTime();
    }
}

