/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.tile;

import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.power.ILowLoadMachine;
import mrtjp.projectred.core.power.ILowLoadPowerLine;
import mrtjp.projectred.core.power.IPowerConductorSource;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.core.tile.BasePoweredBlockEntity;
import mrtjp.projectred.fabrication.block.FabricationMachineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class FabricationMachineBlockEntity
extends BasePoweredBlockEntity
implements ILowLoadMachine {
    protected final PowerConductor conductor = new PowerConductor((IPowerConductorSource)this, 0.01, 160.0);
    private int chargeFlow = 0;
    private boolean isWorking = false;
    private boolean isCharged = false;
    private int remainingWork = 0;
    private int totalWork = 0;

    public FabricationMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveToNBT(tag, lookupProvider);
        this.conductor.save(tag);
        tag.putBoolean("isWorking", this.isWorking);
        tag.putBoolean("isCharged", this.isCharged);
    }

    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadFromNBT(tag, lookupProvider);
        this.conductor.load(tag);
        this.isWorking = tag.getBoolean("isWorking");
        this.isCharged = tag.getBoolean("isCharged");
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).setValue((Property)FabricationMachineBlock.CHARGED, (Comparable)Boolean.valueOf(this.isCharged))).setValue((Property)FabricationMachineBlock.WORKING, (Comparable)Boolean.valueOf(this.isWorking));
    }

    public void tick() {
        if (this.getLevel().isClientSide) {
            return;
        }
        boolean wasCharged = this.isCharged;
        boolean wasWorking = this.isWorking;
        this.conductor.tick();
        this.chargeFlow <<= 1;
        if (this.canConductorWork()) {
            this.chargeFlow |= 1;
        }
        this.isCharged = this.canConductorWork();
        if (!this.isWorking) {
            if (this.canStartWork()) {
                this.isWorking = true;
                this.remainingWork = this.totalWork = this.startWork();
            }
        } else {
            int workDone = this.tickWork(this.remainingWork);
            this.remainingWork -= workDone;
            if (this.remainingWork <= 0) {
                this.isWorking = false;
                this.remainingWork = 0;
                this.totalWork = 0;
                this.finishWork();
            }
        }
        if (this.isCharged != wasCharged || this.isWorking != wasWorking) {
            this.pushBlockState();
        }
    }

    public boolean canConnectPart(IConnectable part, int s, int edgeRot) {
        if (part instanceof ILowLoadMachine) {
            return true;
        }
        return part instanceof ILowLoadPowerLine;
    }

    public PowerConductor getConductor(int dir) {
        return this.conductor;
    }

    public int getConductorCharge() {
        return (int)(this.conductor.getVoltage() * 10.0);
    }

    public int getConductorFlow() {
        return this.chargeFlow;
    }

    public boolean canConductorWork() {
        return this.getConductorCharge() > 600;
    }

    protected void cancelWorkIfNeeded() {
        if (this.isWorking && !this.canStartWork()) {
            this.isWorking = false;
            this.remainingWork = 0;
            this.totalWork = 0;
            this.pushBlockState();
        }
    }

    public int getRemainingWork() {
        return this.remainingWork;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    protected abstract boolean canStartWork();

    protected abstract int startWork();

    protected abstract int tickWork(int var1);

    protected abstract void finishWork();
}

