/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.item;

import java.util.List;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationDataComponents;
import mrtjp.projectred.fabrication.init.FabricationItems;
import mrtjp.projectred.fabrication.item.component.BlueprintDataComponent;
import mrtjp.projectred.fabrication.item.component.ICDataComponent;
import mrtjp.projectred.integration.GateType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class ICBlueprintItem
extends Item {
    public ICBlueprintItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        stack.addToTooltip(FabricationDataComponents.BLUEPRINT_DATA_COMPONENT_TYPE, context, tooltipList::add, tooltipFlag);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null || !player.isCreative()) {
            return InteractionResult.PASS;
        }
        BlueprintDataComponent component = BlueprintDataComponent.getComponent(stack);
        if (component == null || !component.getICData().canFabricate()) {
            return InteractionResult.PASS;
        }
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (blockState.getBlock() == FabricationBlocks.IC_WORKBENCH_BLOCK.get()) {
            return InteractionResult.PASS;
        }
        ItemStack gate = GateType.FABRICATED_GATE.makeStack();
        ICDataComponent.setComponent(gate, component.getICData());
        player.addItem(gate);
        return InteractionResult.SUCCESS;
    }

    public static ItemStack createPhotomaskStack(ItemStack blueprintStack) {
        BlueprintDataComponent component = BlueprintDataComponent.getComponent(blueprintStack);
        ItemStack photomaskStack = new ItemStack((ItemLike)FabricationItems.PHOTOMASK_SET_ITEM.get());
        if (component == null || !component.getICData().canFabricate()) {
            return photomaskStack;
        }
        ICDataComponent.setComponent(photomaskStack, component.getICData());
        return photomaskStack;
    }
}

