/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mrtjp.projectred.fabrication.gui.TabButtonNode;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;

public class TabControllerNode
extends AbstractGuiNode {
    private final List<TabButtonNode> tabButtonList = new LinkedList<TabButtonNode>();
    private final List<TabEntry> tabs = new LinkedList<TabEntry>();

    public void addButtonForTab(IToolbarTab tab) {
        int i = this.tabs.size();
        TabButtonNode button = tab.createButtonNode();
        button.setZPosition(0.1);
        button.setTabState(TabButtonNode.TabState.ALL_CLOSED);
        this.addChild((RedUINode)button);
        this.tabs.add(new TabEntry(i, button, tab));
        this.tabButtonList.add(button);
    }

    public Optional<IToolbarTab> getSelectedTab() {
        for (TabEntry entry : this.tabs) {
            TabButtonNode.TabState state = entry.buttonNode.getRenderState();
            if (state != TabButtonNode.TabState.OPEN && state != TabButtonNode.TabState.MINIMIZED) continue;
            return Optional.of(entry.tab);
        }
        return Optional.empty();
    }

    public IToolbarTab getTab(int index) {
        return this.tabs.get((int)index).tab;
    }

    public void spreadButtonsVertically(int padding) {
        int y = 0;
        for (TabButtonNode button : this.tabButtonList) {
            button.setPosition(0, y);
            y += button.getFrame().height() + padding;
        }
    }

    public void spreadButtonsHorizontally(int padding) {
        int x = 0;
        for (TabButtonNode button : this.tabButtonList) {
            button.setPosition(x, 0);
            x += button.getFrame().width() + padding;
        }
    }

    public void selectInitialTab(int tabIndex) {
        this.openTab(this.tabs.get((int)tabIndex).tab);
    }

    public void openTab(IToolbarTab tab) {
        boolean tabsOpen = false;
        for (TabEntry entry : this.tabs) {
            if (entry.tab == tab) {
                entry.buttonNode.setTabState(TabButtonNode.TabState.OPEN);
                if (!tab.hasBody()) {
                    entry.buttonNode.setTabState(TabButtonNode.TabState.MINIMIZED);
                    continue;
                }
                tabsOpen = true;
                continue;
            }
            entry.buttonNode.setTabState(TabButtonNode.TabState.CLOSED);
        }
        if (!tabsOpen) {
            for (TabEntry entry : this.tabs) {
                if (entry.tab == tab) continue;
                entry.buttonNode.setTabState(TabButtonNode.TabState.ALL_CLOSED);
            }
        }
    }

    public void openTab(Predicate<IToolbarTab> selector) {
        for (TabEntry entry : this.tabs) {
            if (!selector.test(entry.tab)) continue;
            this.openTab(entry.tab);
            return;
        }
    }

    public void closeTab(IToolbarTab tab) {
        boolean tabsOpen = false;
        for (TabEntry entry : this.tabs) {
            if (entry.tab == tab) {
                entry.buttonNode.setTabState(TabButtonNode.TabState.CLOSED);
            }
            if (entry.buttonNode.getRenderState() != TabButtonNode.TabState.OPEN) continue;
            tabsOpen = true;
        }
        if (!tabsOpen) {
            for (TabEntry entry : this.tabs) {
                entry.buttonNode.setTabState(TabButtonNode.TabState.ALL_CLOSED);
            }
        }
    }

    public void minimizeTab(IToolbarTab tab) {
        boolean tabsOpen = false;
        for (TabEntry entry : this.tabs) {
            if (entry.tab == tab) {
                entry.buttonNode.setTabState(TabButtonNode.TabState.MINIMIZED);
            }
            if (entry.buttonNode.getRenderState() != TabButtonNode.TabState.OPEN) continue;
            tabsOpen = true;
        }
        if (!tabsOpen) {
            for (TabEntry entry : this.tabs) {
                if (entry.tab == tab) continue;
                entry.buttonNode.setTabState(TabButtonNode.TabState.ALL_CLOSED);
            }
        }
    }

    public void closeAllTabs() {
        for (TabEntry entry : this.tabs) {
            entry.buttonNode.setTabState(TabButtonNode.TabState.ALL_CLOSED);
        }
    }

    public static interface IToolbarTab {
        public boolean hasBody();

        public void onTabClosed();

        public void onTabOpened();

        public void onTabMinimized();

        public TabButtonNode createButtonNode();
    }

    private static class TabEntry {
        public final int i;
        public final TabButtonNode buttonNode;
        public final IToolbarTab tab;

        public TabEntry(int i, TabButtonNode buttonNode, IToolbarTab tab) {
            this.i = i;
            this.buttonNode = buttonNode;
            this.tab = tab;
        }
    }
}

