/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import java.util.List;
import java.util.Optional;
import mrtjp.projectred.fabrication.editor.tools.HotKeyInteractionZone;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.engine.BaseTile;
import mrtjp.projectred.fabrication.engine.IConnectableICTile;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import mrtjp.projectred.integration.client.GateModelRenderer;
import mrtjp.projectred.integration.part.IGateRenderData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public abstract class GateTile
extends BaseTile
implements IConnectableICTile,
IRotatableICTile,
IGateRenderData {
    public static final int PACKET_ROTATION = 1;
    public static final int PACKET_SHAPE = 2;
    private byte connMask = 0;
    private byte gateShape = 0;
    private byte gateRotation = 0;
    private final ICGateTileType gateTileType;

    public GateTile(ICGateTileType gateTileType) {
        super(gateTileType.tileType);
        this.gateTileType = gateTileType;
    }

    public int getShape() {
        return this.gateShape & 0xFF;
    }

    public void setShape(int shape) {
        this.gateShape = (byte)shape;
    }

    public void preparePlacement(int r) {
        this.setRotation(r);
    }

    @Override
    public void save(CompoundTag tag) {
        tag.putByte("orient", this.gateRotation);
        tag.putByte("shape", this.gateShape);
        tag.putByte("connMask", this.connMask);
    }

    @Override
    public void load(CompoundTag tag) {
        this.gateRotation = tag.getByte("orient");
        this.gateShape = tag.getByte("shape");
        this.connMask = tag.getByte("connMask");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        out.writeByte((int)this.gateRotation);
        out.writeByte((int)this.gateShape);
    }

    @Override
    public void readDesc(MCDataInput in) {
        this.gateRotation = in.readByte();
        this.gateShape = in.readByte();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 1: {
                this.gateRotation = in.readByte();
                break;
            }
            case 2: {
                this.gateShape = in.readByte();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendRotationUpdate() {
        this.getWriteStream(1).writeByte((int)this.gateRotation);
    }

    protected void sendShapeUpdate() {
        this.getWriteStream(2).writeByte((int)this.gateShape);
    }

    protected void rotateAndSend() {
        this.setRotation((this.getRotation() + 1) % 4);
        this.updateConns();
        this.sendRotationUpdate();
        this.notifyNeighbors(15);
        this.getEditor().markTileChange();
    }

    protected void reflectAndSend() {
    }

    protected void configureShapeAndSend(int newShape) {
        if (this.getShape() != newShape) {
            this.setShape(newShape);
            this.updateConns();
            this.sendShapeUpdate();
            this.notifyNeighbors(15);
            this.getEditor().markTileChange();
        }
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        if (this.updateConns()) {
            this.getEditor().markTileChange();
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.updateConns();
        this.onGatePlaced();
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.notifyNeighbors(15);
    }

    @Override
    public void renderTile(CCRenderState ccrs, Transformation t, float partialFrame) {
        GateModelRenderer r = GateModelRenderer.instance();
        r.renderStatic(ccrs, (IGateRenderData)this, t);
        r.renderDynamic(ccrs, (IGateRenderData)this, t, partialFrame);
    }

    protected void notifyNeighbors(int rMask) {
        int absRMask = this.toAbsoluteMask(rMask);
        for (int r = 0; r < 4; ++r) {
            if ((absRMask & 1 << r) == 0) continue;
            int absDir = IRotatableICTile.rotationToDir(r);
            this.getEditor().queueNeighborChange(this.getPos().offset(absDir));
        }
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        double s = 0.125;
        double h = s + 0.03125;
        Cuboid6 box = new Cuboid6(0.0, 0.0, 0.0, s, h, s);
        int i = 1;
        if (this.canRotate()) {
            zones.add(new HotKeyInteractionZone.Builder().keyCode(82).text((Component)Component.translatable((String)"projectred_fabrication.interact.rotate")).bounds(box.copy().add(1.0 - s * (double)i, 0.0, 1.0 - s)).keyAction(this::rotateAndSend).icon(() -> ICRenderTypes.rotateIcon).build());
            ++i;
        }
        if (this.canReflect()) {
            zones.add(new HotKeyInteractionZone.Builder().keyCode(70).text((Component)Component.translatable((String)"projectred_fabrication.interact.reflect")).bounds(box.copy().add(1.0 - s * (double)i, 0.0, 1.0 - s)).keyAction(this::reflectAndSend).icon(() -> ICRenderTypes.reflectIcon).build());
            ++i;
        }
    }

    @Override
    public int getRotation() {
        return this.gateRotation & 3;
    }

    @Override
    public void setRotation(int r) {
        this.gateRotation = (byte)(this.gateRotation & 0xFC | r);
    }

    @Override
    public int getConnMask() {
        return this.connMask & 0xFF;
    }

    @Override
    public void setConnMask(int connMask) {
        this.connMask = (byte)connMask;
    }

    @Override
    public IConnectableICTile getTileTowardsDir(int dir) {
        Optional<BaseTile> tile = this.getMap().getBaseTile(this.getPos().offset(dir));
        if (tile.isPresent() && tile.get() instanceof IConnectableICTile) {
            return (IConnectableICTile)((Object)tile.get());
        }
        return null;
    }

    @Override
    public boolean canConnectTo(IConnectableICTile target, int towardsDir) {
        return this.canGateConnectTo(target, this.toInternalRotation(IRotatableICTile.dirToRotation(towardsDir)));
    }

    @Override
    public void onMaskChanged() {
    }

    public int getRenderIndex() {
        return this.gateTileType.renderIndex;
    }

    public int getOrientation() {
        return this.getRotation() & 3;
    }

    public int shape() {
        return this.gateShape;
    }

    protected void onGatePlaced() {
    }

    protected boolean canRotate() {
        return true;
    }

    protected boolean canReflect() {
        return false;
    }

    protected abstract boolean canGateConnectTo(IConnectableICTile var1, int var2);
}

