/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import net.minecraft.nbt.CompoundTag;

public class ICSimulationContainer {
    private ICSimulation simulation = PRFabricationEngine.instance.deserializeSimulation(PRFabricationEngine.EMPTY_SIMULATION_SERIALIZED);
    private final short[] inputs = new short[]{0, 0, 0, 0};
    private final short[] outputs = new short[]{0, 0, 0, 0};
    private long systemTime = 0L;

    public void setInput(int rotation, short mask) {
        this.inputs[rotation] = mask;
    }

    public int setInputs(short[] inputs) {
        int changeMask = 0;
        for (int r = 0; r < 4; ++r) {
            if (this.inputs[r] == inputs[r]) continue;
            this.inputs[r] = inputs[r];
            changeMask |= 1 << r;
        }
        return changeMask;
    }

    public short getInput(int rotation) {
        return this.inputs[rotation];
    }

    public void setSystemTime(long systemTime) {
        this.systemTime = systemTime;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public void progressTime(long time) {
        this.systemTime += time;
    }

    public short getOutput(int rotation) {
        return this.outputs[rotation];
    }

    public void setFlatMap(ICFlatMap flatMap) {
        this.simulation = new ICSimulation(flatMap);
        this.pushInputs(15);
        this.pushTime();
        this.simulation.computeAll(null);
    }

    public void save(CompoundTag tag) {
        tag.putString("simulation", PRFabricationEngine.instance.serializeSimulation(this.simulation));
        for (int i = 0; i < 4; ++i) {
            tag.putShort("in" + i, this.inputs[i]);
            tag.putShort("out" + i, this.outputs[i]);
        }
        tag.putLong("systemTime", this.systemTime);
    }

    public void load(CompoundTag tag) {
        ICSimulation simulation = PRFabricationEngine.instance.deserializeSimulation(tag.getString("simulation"));
        if (simulation != null) {
            this.simulation = simulation;
        }
        for (int i = 0; i < 4; ++i) {
            this.inputs[i] = tag.getShort("in" + i);
            this.outputs[i] = tag.getShort("out" + i);
        }
        this.systemTime = tag.getLong("systemTime");
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public void pushInputs(int rmask) {
        for (int r = 0; r < 4; ++r) {
            if ((rmask & 1 << r) == 0) continue;
            for (int i = 0; i < 16; ++i) {
                int regId = PRFabricationEngine.inputRegisterId(r, i);
                byte value = (this.inputs[r] & 1 << i) != 0 ? (byte)1 : 0;
                this.simulation.queueRegByteVal(regId, value);
            }
        }
    }

    public void pullInputs(int rmask) {
        for (int r = 0; r < 4; ++r) {
            if ((rmask & 1 << r) == 0) continue;
            this.inputs[r] = 0;
            for (int i = 0; i < 16; ++i) {
                int regId = PRFabricationEngine.inputRegisterId(r, i);
                if (this.simulation.getRegByteVal(regId) == 0) continue;
                int n = r;
                this.inputs[n] = (short)(this.inputs[n] | 1 << i);
            }
        }
    }

    public void pushTime() {
        this.simulation.queueRegLongVal(PRFabricationEngine.REG_TIME, 0, this.systemTime);
    }

    public void pullTime() {
        this.systemTime = this.simulation.getRegLongVal(PRFabricationEngine.REG_TIME, 0);
    }

    public int pullOutputs() {
        short[] newOutputs = new short[4];
        for (int r = 0; r < 4; ++r) {
            for (int i = 0; i < 16; ++i) {
                int regId = PRFabricationEngine.outputRegisterId(r, i);
                int value = this.simulation.getRegByteVal(regId) != 0 ? 1 : 0;
                int n = r;
                newOutputs[n] = (short)(newOutputs[n] | value << i);
            }
        }
        int changeMask = 0;
        for (int r = 0; r < 4; ++r) {
            if (this.outputs[r] == newOutputs[r]) continue;
            this.outputs[r] = newOutputs[r];
            changeMask |= 1 << r;
        }
        return changeMask;
    }

    public byte pullRegisterValue(int regId) {
        return this.simulation.getRegByteVal(regId);
    }

    public short pullShortValue(int r1, int r0) {
        return this.simulation.getRegShortVal(r1, r0);
    }

    public short pullShortValue(int[] r, int offset) {
        return this.simulation.getRegShortVal(r, offset);
    }

    public int pullIntValue(int r3, int r2, int r1, int r0) {
        return this.simulation.getRegIntVal(r3, r2, r1, r0);
    }

    public int pullIntValue(int[] r, int offset) {
        return this.simulation.getRegIntVal(r, offset);
    }

    public long pullLongValue(int r7, int r6, int r5, int r4, int r3, int r2, int r1, int r0) {
        return this.simulation.getRegLongVal(r7, r6, r5, r4, r3, r2, r1, r0);
    }

    public long pullLongValue(int[] r, int offset) {
        return this.simulation.getRegLongVal(r, offset);
    }

    public void simulate() {
        this.simulation.propagate(null);
    }
}

