/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor;

import java.util.List;
import javax.annotation.Nullable;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class EditorDataUtils {
    public static final String KEY_FORMAT = "format";
    public static final String KEY_ACTIVE = "active";
    public static final String KEY_IC_NAME = "ic_name";
    public static final String KEY_TILE_MAP = "tile_map";
    public static final String KEY_TILE_COUNT = "tile_count";
    public static final String KEY_IS_BUILT = "is_built";
    public static final String KEY_IO_SPEC = "io_spec";
    public static final String KEY_COMP_STATE = "state";
    public static final String KEY_SIM_START_TIME = "sim_start_time";
    public static final String KEY_COMPILE_FORMAT = "compile_format";
    public static final String KEY_FLAT_MAP = "flat_map";
    public static final String KEY_SIMULATION = "sim_cont";
    public static final String KEY_COMPILER_LOG = "compiler_log";
    public static final String KEY_AUTO_COMPILE_ENABLE = "auto_compile_enable";
    public static final String KEY_AUTO_COMPILE_ALLOWED = "auto_compile_allowed";
    public static final String KEY_COMPLETED_STEPS = "completed_steps";
    public static final String KEY_CURRENT_PATH = "current_path";
    public static final String KEY_PROBLEMS_LIST = "problems";
    public static final String KEY_ERROR_COUNT = "error_count";
    public static final String KEY_WARNING_COUNT = "warning_count";

    public static int getFormat(CompoundTag tag) {
        return tag.getInt(KEY_FORMAT);
    }

    public static boolean hasEditorData(@Nullable CompoundTag tag) {
        return tag != null && tag.contains(KEY_FORMAT) && tag.contains(KEY_ACTIVE) && tag.contains(KEY_TILE_MAP);
    }

    public static boolean hasFabricationTarget(@Nullable CompoundTag tag) {
        return tag != null && tag.contains(KEY_IS_BUILT) && tag.contains(KEY_FLAT_MAP);
    }

    public static boolean canFabricate(@Nullable CompoundTag tag) {
        return EditorDataUtils.hasFabricationTarget(tag) && EditorDataUtils.isBuilt(tag) && EditorDataUtils.isCompileFormatValid(tag) && EditorDataUtils.getErrorCount(tag) == 0;
    }

    public static boolean isBuilt(CompoundTag tag) {
        return tag.getBoolean(KEY_IS_BUILT);
    }

    public static boolean isCompileFormatValid(CompoundTag tag) {
        return tag.getInt(KEY_COMPILE_FORMAT) == 1;
    }

    public static int getErrorCount(CompoundTag tag) {
        return tag.getCompound(KEY_COMPILER_LOG).getInt(KEY_ERROR_COUNT);
    }

    public static int getWarningCount(CompoundTag tag) {
        return tag.getCompound(KEY_COMPILER_LOG).getInt(KEY_WARNING_COUNT);
    }

    public static CompoundTag createFabricationCopy(CompoundTag editorTag) {
        CompoundTag copy = new CompoundTag();
        copy.putInt(KEY_COMPILE_FORMAT, editorTag.getInt(KEY_COMPILE_FORMAT));
        copy.putBoolean(KEY_IS_BUILT, editorTag.getBoolean(KEY_IS_BUILT));
        copy.putString(KEY_IC_NAME, editorTag.getString(KEY_IC_NAME));
        copy.putInt(KEY_TILE_COUNT, editorTag.getInt(KEY_TILE_COUNT));
        copy.put(KEY_IO_SPEC, (Tag)editorTag.getCompound(KEY_IO_SPEC));
        copy.putString(KEY_FLAT_MAP, editorTag.getString(KEY_FLAT_MAP));
        return copy;
    }

    public static InterfaceSpec getInterfaceSpec(CompoundTag tag) {
        return InterfaceSpec.createFrom(tag, KEY_IO_SPEC);
    }

    public static void saveTileCoord(CompoundTag tag, String key, TileCoord coord) {
        tag.putByte(key + "_x", (byte)coord.x);
        tag.putByte(key + "_y", (byte)coord.y);
        tag.putByte(key + "_z", (byte)coord.z);
    }

    public static TileCoord loadTileCoord(CompoundTag tag, String key) {
        return new TileCoord((int)tag.getByte(key + "_x"), (int)tag.getByte(key + "_y"), (int)tag.getByte(key + "_z"));
    }

    public static void saveTileCoordList(CompoundTag tag, String key, Iterable<TileCoord> coordList) {
        ListTag list = new ListTag();
        for (TileCoord coord : coordList) {
            list.add((Object)EditorDataUtils.tileCoordToNBT(coord));
        }
        tag.put(key, (Tag)list);
    }

    public static void loadTileCoordList(CompoundTag tag, String key, List<TileCoord> coordList) {
        ListTag list = tag.getList(key, 10);
        for (int i = 0; i < list.size(); ++i) {
            coordList.add(EditorDataUtils.tileCoordFromNBT(list.getCompound(i)));
        }
    }

    public static CompoundTag tileCoordToNBT(TileCoord coord) {
        CompoundTag tag = new CompoundTag();
        EditorDataUtils.saveTileCoord(tag, "", coord);
        return tag;
    }

    public static TileCoord tileCoordFromNBT(CompoundTag tag) {
        return EditorDataUtils.loadTileCoord(tag, "");
    }
}

