/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.client.renderer;

import com.illusivesoulworks.comforts.common.block.entity.BaseComfortsBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BaseComfortsBlockEntityRenderer<T extends BaseComfortsBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ModelLayerLocation SLEEPING_BAG_HEAD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"sleeping_bag_head"), "main");
    public static final ModelLayerLocation SLEEPING_BAG_FOOT = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"sleeping_bag_foot"), "main");
    public static final ModelLayerLocation HAMMOCK_HEAD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"hammock_head"), "main");
    public static final ModelLayerLocation HAMMOCK_FOOT = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)"hammock_foot"), "main");
    private final String type;
    protected ModelPart headPiece;
    protected ModelPart footPiece;

    public BaseComfortsBlockEntityRenderer(BlockEntityRendererProvider.Context ctx, String type, ModelLayerLocation headModel, ModelLayerLocation footModel) {
        this.headPiece = ctx.bakeLayer(headModel);
        this.footPiece = ctx.bakeLayer(footModel);
        this.type = type;
    }

    public void render(BaseComfortsBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Material material = new Material(InventoryMenu.BLOCK_ATLAS, ResourceLocation.fromNamespaceAndPath((String)"comforts", (String)("entity/" + this.type + "/" + blockEntity.getColor().getName())));
        Level level = blockEntity.getLevel();
        if (level != null) {
            BlockState blockstate = blockEntity.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)BlockEntityType.BED, BedBlock::getBlockType, BedBlock::getConnectedDirection, (DirectionProperty)ChestBlock.FACING, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)blockEntity.getBlockPos(), (p_228846_0_, p_228846_1_) -> false);
            int i = ((Int2IntFunction)icallbackwrapper.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(combinedLightIn);
            this.renderPiece(matrixStack, buffer, blockstate.getValue((Property)BedBlock.PART) == BedPart.HEAD, (Direction)blockstate.getValue((Property)BedBlock.FACING), material, i, combinedOverlayIn, false);
        } else {
            this.renderPiece(matrixStack, buffer, true, Direction.SOUTH, material, combinedLightIn, combinedOverlayIn, false);
            this.renderPiece(matrixStack, buffer, false, Direction.SOUTH, material, combinedLightIn, combinedOverlayIn, true);
        }
    }

    protected void renderPiece(PoseStack matrixStack, MultiBufferSource buffer, boolean isHead, Direction direction, Material material, int light, int overlay, boolean p_228847_8_) {
        this.headPiece.visible = isHead;
        this.footPiece.visible = !isHead;
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.1875, p_228847_8_ ? -1.0 : 0.0);
        matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f + direction.toYRot()));
        matrixStack.translate(-0.5, -0.5, -0.5);
        VertexConsumer ivertexbuilder = material.buffer(buffer, RenderType::entitySolid);
        this.headPiece.render(matrixStack, ivertexbuilder, light, overlay);
        this.footPiece.render(matrixStack, ivertexbuilder, light, overlay);
        matrixStack.popPose();
    }
}

