/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.neoforge;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.block.IAntiquable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.LunchBoxBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.neoforge.FluidHandlerItemCap;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CapabilityHandler {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"supplementaries");
    private static final Supplier<AttachmentType<AntiquableAttachment>> ANTIQUABLE_ATTACHMENT = ATTACHMENT_TYPES.register("antique_ink", () -> AttachmentType.builder(() -> new AntiquableAttachment(false)).serialize(AntiquableAttachment.CODEC).build());
    public static final BlockCapability<IAntiquable, Void> ANTIQUE_TEXT_CAP = BlockCapability.createVoid((ResourceLocation)Supplementaries.res("antique_ink"), IAntiquable.class);
    public static final BlockCapability<IWashable, @Nullable Direction> WASHABLE_CAP = BlockCapability.create((ResourceLocation)Supplementaries.res("washable"), IWashable.class, Direction.class);
    public static final EntityCapability<ICatchableMob, Void> CATCHABLE_MOB = EntityCapability.createVoid((ResourceLocation)Supplementaries.res("antique_ink"), ICatchableMob.class);
    private static final Map<Class<?>, BaseCapability<?, ?>> TOKENS = Map.of(IAntiquable.class, ANTIQUE_TEXT_CAP, ICatchableMob.class, CATCHABLE_MOB, IWashable.class, WASHABLE_CAP);

    public static void init(IEventBus bus) {
        ATTACHMENT_TYPES.register(bus);
        bus.addListener(CapabilityHandler::register);
    }

    public static <T> BaseCapability<?, ?> getToken(Class<T> capClass) {
        return TOKENS.get(capClass);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(ANTIQUE_TEXT_CAP, BlockEntityType.SIGN, AntiquableAttachment::get);
        event.registerBlockEntity(ANTIQUE_TEXT_CAP, BlockEntityType.HANGING_SIGN, AntiquableAttachment::get);
        event.registerEntity(Capabilities.ItemHandler.ENTITY, ModEntities.DISPENSER_MINECART.get(), (entity, ctx) -> new InvWrapper((Container)entity));
        event.registerEntity(Capabilities.ItemHandler.ENTITY_AUTOMATION, ModEntities.DISPENSER_MINECART.get(), (entity, ctx) -> new InvWrapper((Container)entity));
        List<BlockEntityType<LunchBoxBlockTile>> nonSided = List.of(ModRegistry.PRESENT_TILE.get(), ModRegistry.TRAPPED_PRESENT_TILE.get(), ModRegistry.SAFE_TILE.get(), ModRegistry.SACK_TILE.get(), ModRegistry.LUNCH_BASKET_TILE.get());
        for (BlockEntityType<LunchBoxBlockTile> type : nonSided) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, type, (container, side) -> new InvWrapper((Container)container));
        }
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModRegistry.CANNON_TILE.get(), (sidedContainer, side) -> side == null ? new InvWrapper((Container)sidedContainer) : new SidedInvWrapper((WorldlyContainer)sidedContainer, side));
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidBucketWrapper(stack), new ItemLike[]{(ItemLike)ModFluids.LUMISENE_BUCKET.get()});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidHandlerItemCap((ItemStack)stack, 250, Items.GLASS_BOTTLE, ModFluids.LUMISENE_FLUID.get()), new ItemLike[]{(ItemLike)ModFluids.LUMISENE_BOTTLE.get()});
    }

    public static final class AntiquableAttachment
    implements IAntiquable {
        public static final Codec<AntiquableAttachment> CODEC = Codec.BOOL.xmap(AntiquableAttachment::new, a -> a.on);
        private boolean on;

        public AntiquableAttachment(boolean on) {
            this.on = on;
        }

        @Override
        public boolean supplementaries$isAntique() {
            return this.on;
        }

        @Override
        public void supplementaries$setAntique(boolean hasInk) {
            this.on = hasInk;
        }

        private static AntiquableAttachment get(BlockEntity signBlockEntity, Void direction) {
            return (AntiquableAttachment)signBlockEntity.getData(ANTIQUABLE_ATTACHMENT);
        }
    }
}

