/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureCollager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.SlimedRenderTypes;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.items.CannonBoatItem;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.dynamicpack.ModServerDynamicResources;
import net.mehvahdjukaar.supplementaries.dynamicpack.MojangNeedsToAddMoreCopper;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ModClientDynamicResources
extends DynamicClientResourceProvider {
    public ModClientDynamicResources() {
        super(Supplementaries.res("generated_pack"), ClientConfigs.General.DYNAMIC_ASSETS_GEN_MODE.get().toStrategy());
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("minecraft");
    }

    public boolean needsToRegenerate() {
        return super.needsToRegenerate() || PlatHelper.isDev();
    }

    public void reload(ResourceManager manager, IProgressTracker reporter) {
        ColoredMapHandler.clearCache();
        SlimedRenderTypes.clear();
        BlackboardTextureManager.closeAll();
        super.reload(manager, reporter);
        GlobeManager.refreshColorsAndTextures(manager);
        ColorHelper.refreshBubbleColors(manager);
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            this.addHeads(manager, sink);
            this.addRopeArrowModel(manager, sink);
            this.addTatteredBook(manager, sink);
            this.addMissingFlagPatterns(manager, sink);
            this.moveGates(manager, sink);
            MojangNeedsToAddMoreCopper.run(manager, sink);
        });
        executor.accept(this::addSignPostAssets);
        executor.accept(this::generateBoatTextures);
    }

    private void moveGates(ResourceManager manager, ResourceSink sink) {
        if (CompatHandler.QUARK && !CommonConfigs.Building.GOLD_BARS_ENABLED.get().booleanValue()) {
            sink.copyResource(manager, ResType.BLOCK_TEXTURES.getPath(Supplementaries.res("gold_gate_bottom_old")), ResType.BLOCK_TEXTURES.getPath(Supplementaries.res("gold_gate_bottom")), false);
            sink.copyResource(manager, ResType.BLOCK_TEXTURES.getPath(Supplementaries.res("gold_gate_top_old")), ResType.BLOCK_TEXTURES.getPath(Supplementaries.res("gold_gate_top")), false);
        }
        if (MiscUtils.FESTIVITY.isChristmas()) {
            sink.copyResource(manager, ResType.ITEM_TEXTURES.getPath(Supplementaries.res("party_hat")), ResType.ITEM_TEXTURES.getPath(Supplementaries.res("party_hat_christmas")), false);
        }
    }

    private void addMissingFlagPatterns(ResourceManager manager, ResourceSink sink) {
        Map textures = manager.listResources("textures/entity/banner", resourceLocation -> resourceLocation.getPath().endsWith(".png") && !resourceLocation.getPath().replace("textures/entity/banner/", "").contains("/"));
        TextureCollager collager = TextureCollager.builder((int)64, (int)64, (int)32, (int)16).copyFrom(3, 13, 16, 16).to(6, 2, 12, 12).bilinearScaling().build();
        for (ResourceLocation id : textures.keySet()) {
            String namespace = id.getNamespace();
            if (namespace.equals("minecraft")) continue;
            String name = id.getPath().replace("textures/entity/banner/", "");
            ResourceLocation newPath = Supplementaries.res("entity/banner/flags/" + id.getNamespace() + "/" + name.substring(0, name.length() - 4));
            sink.addTextureIfNotPresent(manager, newPath, () -> {
                TextureImage textureImage;
                block8: {
                    TextureImage oldText = TextureImage.open((ResourceManager)manager, (ResourceLocation)id.withPath(p -> p.replace("textures/", "")));
                    try {
                        TextureImage newImage = TextureOps.createScaled((TextureImage)oldText, (float)0.5f, (float)0.25f);
                        newImage.clear();
                        collager.apply(oldText, newImage);
                        textureImage = newImage;
                        if (oldText == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (oldText != null) {
                                try {
                                    oldText.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    oldText.close();
                }
                return textureImage;
            });
        }
    }

    private void addSignPostAssets(ResourceManager manager, ResourceSink sink) {
        Respriter respriter;
        TextureImage template;
        StaticResource spItemModel = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("way_sign_oak")));
        StaticResource spBlockModel = StaticResource.getOrThrow((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Supplementaries.res("way_signs/way_sign_oak")));
        ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((Item)sign).getPath();
            sink.addSimilarJsonResource(manager, spItemModel, "way_sign_oak", id);
            sink.addSimilarJsonResource(manager, spBlockModel, "way_sign_oak", id);
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/way_signs/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("item/way_signs/" + Utils.getID((Item)sign).getPath());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    Item signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                             TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/way_signs/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign, (TextureImage)signMask);
                            try (TextureImage newImage = respriter.recolor(targetPalette);){
                                try (TextureImage scribbles = ModClientDynamicResources.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("item/way_signs/sign_scribbles_mask"), Supplementaries.res("item/way_signs/scribbles_template"));){
                                    TextureOps.applyOverlay((TextureImage)newImage, (TextureImage[])new TextureImage[]{scribbles});
                                }
                                catch (Exception ex) {
                                    Supplementaries.LOGGER.error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                                }
                                sink.addTexture(textureRes, newImage);
                            }
                        }
                        catch (Exception ex) {
                            Supplementaries.LOGGER.error("Could not find sign texture for wood explosionType {}. Using plank texture : {}", wood, (Object)ex);
                        }
                    } else {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            try (TextureImage newImage = respriter.recolor(targetPalette);){
                                sink.addTexture(textureRes, newImage);
                            }
                        }
                        catch (Exception ex) {
                            Supplementaries.LOGGER.error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            Supplementaries.LOGGER.error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("block/way_signs/way_sign_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("block/way_signs/" + Utils.getID((Item)sign).getPath());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        try (TextureImage newImage = respriter.recolor(palette);){
                            sink.addTexture(textureRes, newImage);
                        }
                    }
                    catch (Exception ex) {
                        Supplementaries.LOGGER.error("Failed to generate Way Sign block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            Supplementaries.LOGGER.error("Could not generate any Way Sign block texture : ", (Throwable)ex);
        }
    }

    private void addTatteredBook(ResourceManager manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            sink.appendModelOverride(manager, ResourceLocation.withDefaultNamespace((String)"written_book"), e -> e.add(new ItemOverride(ResourceLocation.withDefaultNamespace((String)"item/written_book_tattered"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
            sink.appendModelOverride(manager, ResourceLocation.withDefaultNamespace((String)"filled_map"), e -> e.add(new ItemOverride(ResourceLocation.withDefaultNamespace((String)"item/antique_map"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
        }
    }

    private void addRopeArrowModel(ResourceManager manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            sink.appendModelOverride(manager, ResourceLocation.withDefaultNamespace((String)"crossbow"), e -> e.add(new ItemOverride(ResourceLocation.withDefaultNamespace((String)"item/crossbow_rope_arrow"), List.of(new ItemOverride.Predicate(ResourceLocation.withDefaultNamespace((String)"charged"), 1.0f), new ItemOverride.Predicate(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
    }

    private void addHeads(ResourceManager manager, ResourceSink sink) {
        TextureImage eyeText;
        TextureImage text2;
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue() && ClientConfigs.Tweaks.HEAD_VANILLA.get().booleanValue()) {
            try {
                text2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/enderman/enderman"));
                try {
                    eyeText = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/enderman/enderman_eyes"));
                    try {
                        sink.addTexture(Supplementaries.res("entity/enderman_head"), text2);
                        sink.addTexture(Supplementaries.res("entity/enderman_head_eyes"), eyeText);
                    }
                    finally {
                        if (eyeText != null) {
                            eyeText.close();
                        }
                    }
                }
                finally {
                    if (text2 != null) {
                        text2.close();
                    }
                }
            }
            catch (Exception text2) {
                // empty catch block
            }
        }
        if (CommonConfigs.Building.SPIDER_HEAD_ENABLED.get().booleanValue() && ClientConfigs.Tweaks.HEAD_VANILLA.get().booleanValue()) {
            try {
                text2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/spider/spider"));
                try {
                    eyeText = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/spider_eyes"));
                    try {
                        sink.addTexture(Supplementaries.res("entity/spider_head"), text2);
                        sink.addTexture(Supplementaries.res("entity/spider_head_eyes"), eyeText);
                    }
                    finally {
                        if (eyeText != null) {
                            eyeText.close();
                        }
                    }
                }
                finally {
                    if (text2 != null) {
                        text2.close();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void generateBoatTextures(ResourceManager manager, ResourceSink sink) {
        TextureImage template;
        StaticResource itemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("cannon_boat_oak")));
        ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, sled) -> {
            try {
                sink.addSimilarJsonResource(manager, itemModel, "cannon_boat_oak", wood.getVariantId("cannon_boat"));
            }
            catch (Exception ex) {
                Supplementaries.LOGGER.error("Failed to generate Cannon Boat item model for {} : {}", (Object)sled, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/boat/oak"));
            try (TextureImage bambooTemplate = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"entity/boat/bamboo"));){
                Respriter respriter = Respriter.of((TextureImage)template);
                Respriter respriter2 = Respriter.of((TextureImage)bambooTemplate);
                ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, sled) -> {
                    ResourceLocation textureRes = Supplementaries.res("entity/cannon_boat/" + wood.getTexturePath());
                    sink.addTextureIfNotPresent(manager, textureRes, () -> {
                        TextureImage textureImage;
                        block8: {
                            TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));
                            try {
                                Palette targetPalette = Palette.fromImage((TextureImage)plankTexture);
                                Respriter r = wood.toVanillaBoatOrOak() == Boat.Type.BAMBOO ? respriter2 : respriter;
                                textureImage = r.recolor(targetPalette);
                                if (plankTexture == null) break block8;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (plankTexture != null) {
                                        try {
                                            plankTexture.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            plankTexture.close();
                        }
                        return textureImage;
                    });
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            Supplementaries.LOGGER.error("Could not generate any sled entity texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/cannon_boat/cannon_boat_oak"));
            try (TextureImage boatMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/cannon_boat/mask"));){
                Palette palette = Palette.fromImage((TextureImage)template, (TextureImage)boatMask);
                Respriter respriter = Respriter.ofPalette((TextureImage)template, (Palette)palette);
                ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, boat) -> {
                    ResourceLocation textureRes = Supplementaries.res("item/cannon_boat/" + Utils.getID((Item)boat).getPath());
                    sink.addTextureIfNotPresent(manager, textureRes, () -> this.createBoatTexture(manager, (WoodType)wood, (CannonBoatItem)((Object)boat), respriter));
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            Supplementaries.LOGGER.error("Could not generate any Cannon Boat item texture : ", (Throwable)ex);
        }
    }

    @Nullable
    private TextureImage createBoatTexture(ResourceManager manager, WoodType wood, CannonBoatItem cannonBoat, Respriter respriter) {
        Palette targetPalette;
        TextureImage newImage = null;
        Item boat = wood.getItemOfThis("boat");
        if (boat != null) {
            try (TextureImage vanillaBoat = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)boat));){
                targetPalette = Palette.fromImage((TextureImage)vanillaBoat);
                newImage = respriter.recolor(targetPalette);
            }
            catch (Exception ex) {
                Supplementaries.LOGGER.warn("Could not find boat texture for wood type {}. Using plank texture : {}", (Object)wood, (Object)ex);
            }
        }
        if (newImage == null) {
            try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                newImage = respriter.recolor(targetPalette);
            }
            catch (Exception ex) {
                Supplementaries.LOGGER.error("Failed to generate Cannon Boat item texture for for {} : {}", (Object)cannonBoat, (Object)ex);
            }
        }
        return newImage;
    }

    private static void generateTagTranslations() {
        JsonObject jo = new JsonObject();
        for (Map.Entry<ResourceLocation, Resource> e : ModServerDynamicResources.TAG_TRANSLATION_HACK.entrySet()) {
            ResourceLocation id = e.getKey();
            if (!id.getNamespace().equals("supplementaries")) continue;
            String path = id.getPath();
            path = path.replace("tags/", "").replace(".json", "");
            String tr = path.substring(path.lastIndexOf("/") + 1);
            jo.addProperty("supplementaries:" + path, LangBuilder.getReadableName((String)tr));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static TextureImage recolorFromVanilla(ResourceManager manager, TextureImage vanillaTexture, ResourceLocation vanillaMask, ResourceLocation templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        MojangNeedsToAddMoreCopper.runTranslations(lang);
        ModRegistry.WAY_SIGN_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.way_sign", (BlockType)type, (Item)item));
        ModRegistry.CANNON_BOAT_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.cannon_boat", (BlockType)type, (Item)item));
        String bambooSpikes = lang.getEntry("item.supplementaries.bamboo_spikes_tipped.effect");
        if (bambooSpikes == null) {
            return;
        }
        for (Potion p : BuiltInRegistries.POTION) {
            Optional<Holder> holder = Optional.of(BuiltInRegistries.POTION.wrapAsHolder((Object)p));
            String key = Potion.getName(holder, (String)"item.supplementaries.bamboo_spikes_tipped.effect.");
            String arrowName = lang.getEntry(Potion.getName(holder, (String)"item.minecraft.tipped_arrow.effect."));
            if (arrowName == null) {
                lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)Utils.getID((Potion)p).getPath())));
                continue;
            }
            lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)arrowName.toLowerCase(Locale.ROOT).replace("arrow of ", ""))));
        }
    }
}

