/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TatteredBookRecipe
extends CustomRecipe {
    private final Ingredient requiredBook = Ingredient.of((ItemLike[])new ItemLike[]{Items.WRITTEN_BOOK});
    private final Ingredient requiredInk;
    private final boolean setAntique;

    public TatteredBookRecipe(CraftingBookCategory category, Ingredient antiqueInk, boolean antique) {
        super(category);
        this.requiredInk = antiqueInk;
        this.setAntique = antique;
    }

    public boolean matches(CraftingInput inv, Level level) {
        ItemStack ink = null;
        ItemStack book = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (this.isValidBook(stack)) {
                if (book != null) {
                    return false;
                }
                book = stack;
                continue;
            }
            if (this.requiredInk.test(stack)) {
                if (ink != null) {
                    return false;
                }
                ink = stack;
                continue;
            }
            return false;
        }
        return book != null && ink != null;
    }

    private boolean isValidBook(ItemStack stack) {
        WrittenBookContent content = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
        return content != null && (content.generation() == 0 || !this.setAntique) && this.requiredBook.test(stack) && AntiqueInkItem.hasAntiqueInk(stack) != this.setAntique;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!this.isValidBook(stack)) continue;
            ItemStack s = stack.copy();
            s.setCount(1);
            AntiqueInkItem.setAntiqueInk(s, this.setAntique);
            return s;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.ANTIQUE_BOOK.get();
    }

    public static class Serializer
    implements RecipeSerializer<TatteredBookRecipe> {
        private static final MapCodec<TatteredBookRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.requiredInk), (App)Codec.BOOL.fieldOf("set_antique").forGetter(recipe -> recipe.setAntique)).apply((Applicative)instance, TatteredBookRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, TatteredBookRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.requiredInk, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.setAntique, TatteredBookRecipe::new);

        public MapCodec<TatteredBookRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TatteredBookRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

