/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.supplementaries.common.utils.SoapWashableHelper;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SoapClearRecipe
extends CustomRecipe {
    private final Ingredient soap;
    private final int dyeAmount;

    public SoapClearRecipe(CraftingBookCategory category, Ingredient soap, int amount) {
        super(category);
        this.soap = soap;
        this.dyeAmount = amount;
    }

    public boolean matches(CraftingInput craftingContainer, Level level) {
        int dyes = 0;
        int soaps = 0;
        for (int k = 0; k < craftingContainer.size(); ++k) {
            boolean isColored;
            ItemStack itemstack = craftingContainer.getItem(k);
            if (itemstack.isEmpty()) continue;
            Item item = itemstack.getItem();
            boolean bl = isColored = BlocksColorAPI.getColor((Item)item) != null && SoapWashableHelper.canCleanColor(item);
            if (isColored || itemstack.has(DataComponents.DYED_COLOR) || this.hasTrim(item)) {
                ++dyes;
                continue;
            }
            if (!this.soap.test(itemstack)) {
                return false;
            }
            ++soaps;
        }
        return soaps == 1 && dyes == this.dyeAmount;
    }

    private boolean hasTrim(Item item) {
        return false;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack toRecolor = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            Item item;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || BlocksColorAPI.getColor((Item)(item = stack.getItem())) == null && !stack.has(DataComponents.DYED_COLOR) && !this.hasTrim(item)) continue;
            toRecolor = stack.copyWithCount(1);
        }
        Item i = toRecolor.getItem();
        if (toRecolor.has(ModComponents.CONFETTI_COLORS.get())) {
            ItemStack result = toRecolor.copy();
            result.remove(ModComponents.CONFETTI_COLORS.get());
            return result;
        }
        if (toRecolor.has(DataComponents.DYED_COLOR)) {
            ItemStack result = toRecolor.copy();
            ItemStack def = toRecolor.getItem().getDefaultInstance();
            if (def.has(DataComponents.DYED_COLOR)) {
                result.set(DataComponents.DYED_COLOR, (Object)((DyedItemColor)def.get(DataComponents.DYED_COLOR)));
            } else {
                result.remove(DataComponents.DYED_COLOR);
            }
            return result;
        }
        Item recolored = BlocksColorAPI.changeColor((Item)i, null);
        ItemStack result = recolored != null ? toRecolor.transmuteCopy((ItemLike)recolored, 1) : toRecolor.copy();
        result.setCount(1);
        return result;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.SOAP_CLEARING.get();
    }

    public static class Serializer
    implements RecipeSerializer<SoapClearRecipe> {
        private static final MapCodec<SoapClearRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.soap), (App)Codec.INT.optionalFieldOf("dyed_items_amount", (Object)1).forGetter(recipe -> recipe.dyeAmount)).apply((Applicative)instance, SoapClearRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SoapClearRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.soap, (StreamCodec)ByteBufCodecs.VAR_INT, recipe -> recipe.dyeAmount, SoapClearRecipe::new);

        public MapCodec<SoapClearRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SoapClearRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

