/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class GoldTrapdoorBlock
extends TrapDoorBlock {
    public GoldTrapdoorBlock(BlockBehaviour.Properties properties) {
        super(BlockSetType.GOLD, properties);
    }

    public boolean canBeOpened(BlockState state) {
        return (Boolean)state.getValue((Property)POWERED) == false;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.canBeOpened(state)) {
            state = (BlockState)state.cycle((Property)OPEN);
            level.setBlock(pos, state, 2);
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
            }
            this.playSound(player, level, pos, (Boolean)state.getValue((Property)OPEN));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean hasPower;
        if (!worldIn.isClientSide && (hasPower = worldIn.hasNeighborSignal(pos)) != (Boolean)state.getValue((Property)POWERED)) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasPower)), 2);
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                worldIn.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = this.defaultBlockState();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        Direction direction = context.getClickedFace();
        blockstate = !context.replacingClickedOnBlock() && direction.getAxis().isHorizontal() ? (BlockState)((BlockState)blockstate.setValue((Property)FACING, (Comparable)direction)).setValue((Property)HALF, (Comparable)(context.getClickLocation().y - (double)context.getClickedPos().getY() > 0.5 ? Half.TOP : Half.BOTTOM)) : (BlockState)((BlockState)blockstate.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)HALF, (Comparable)(direction == Direction.UP ? Half.BOTTOM : Half.TOP));
        if (context.getLevel().hasNeighborSignal(context.getClickedPos())) {
            blockstate = (BlockState)blockstate.setValue((Property)POWERED, (Comparable)Boolean.TRUE);
        }
        return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }
}

