/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.IconHitEffectsPart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.Collections;
import java.util.function.Consumer;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.transmission.WireType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class BaseWirePart
extends BaseMultipart
implements IconHitEffectsPart {
    protected static final int KEY_UPDATE = 0;
    private final WireType wireType;

    public BaseWirePart(WireType wireType) {
        this.wireType = wireType;
    }

    public abstract void preparePlacement(Direction var1);

    public WireType getWireType() {
        return this.wireType;
    }

    public MultipartType<?> getType() {
        return this.getWireType().getPartType();
    }

    protected ItemStack getItem() {
        return this.getWireType().makeStack();
    }

    public Iterable<ItemStack> getDrops() {
        return Collections.singleton(this.getItem());
    }

    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return this.getItem();
    }

    public final void sendUpdate(Consumer<MCDataOutput> func) {
        this.sendUpdate(0, func);
    }

    public final void readUpdate(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    protected final void sendUpdate(int key, Consumer<MCDataOutput> func) {
        super.sendUpdate(p -> {
            p.writeByte(key);
            func.accept((MCDataOutput)p);
        });
    }

    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 0: {
                this.readDesc(packet);
                break;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRenderHue() {
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getIcon() {
        return this.getWireType().getTextures().get(0);
    }

    public boolean useStaticRenderer() {
        return (Boolean)Configurator.CLIENT.staticWires.get();
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(this.getShape(CollisionContext.empty()).bounds());
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBreakingIcon(PartRayTraceResult hit) {
        return this.getIcon();
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBrokenIcon(int side) {
        return this.getIcon();
    }
}

