/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.huge;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.PoweredEngineShaftBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class HugeDieselEngineBlock
extends Block
implements IBE<HugeDieselEngineBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public HugeDieselEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)DieselEngineBlock.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        for (EngineUpgrades upgrade : EngineUpgrades.allUpgrades) {
            if (upgrade == EngineUpgrades.EMPTY || !upgrade.getItem().is(stack.getItem())) continue;
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (!upgrade.canAddOn((IEngine)be)) {
                    return;
                }
                if (be.upgrade != EngineUpgrades.EMPTY) {
                    return;
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                be.upgrade = upgrade;
                be.sendData();
                IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
            });
            return ItemInteractionResult.SUCCESS;
        }
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(stack)) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        if (!((Boolean)CDGConfig.ENGINES_FILLED_WITH_ITEMS.get()).booleanValue() || stack.isEmpty() || !((blockEntity = level.getBlockEntity(pos)) instanceof SmartBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        SmartBlockEntity be2 = (SmartBlockEntity)blockEntity;
        IFluidHandler tank = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, be2.getBlockPos(), null);
        if (tank == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() instanceof BucketItem || stack.getItem() instanceof MilkBucketItem) {
            Fluid fluid;
            Item item = stack.getItem();
            if (item instanceof BucketItem) {
                BucketItem bi = (BucketItem)item;
                v0 = bi.content;
            } else {
                v0 = fluid = (Fluid)NeoForgeMod.MILK.get();
            }
            if (!tank.getFluidInTank(0).isEmpty()) {
                return ItemInteractionResult.FAIL;
            }
            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            if (!player.isCreative()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            }
            return ItemInteractionResult.SUCCESS;
        }
        IFluidHandlerItem itemTank = (IFluidHandlerItem)Capabilities.FluidHandler.ITEM.getCapability(stack, null);
        if (itemTank == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        itemTank.drain(tank.fill(itemTank.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        return ItemInteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), be -> {
            if (be.upgrade != EngineUpgrades.EMPTY && !context.getLevel().isClientSide) {
                if (!context.getPlayer().isCreative()) {
                    context.getPlayer().getInventory().placeItemBackInInventory(be.upgrade.getItem());
                }
                be.upgrade = EngineUpgrades.EMPTY;
                be.sendData();
                IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
            }
        });
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DieselEngineBlock.POWERED, FACING});
        super.createBlockStateDefinition(builder);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean moving) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DieselEngineBlock.POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(pos))));
        super.neighborChanged(state, level, pos, block, otherPos, moving);
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction preferredSide = null;
        for (Direction side : Iterate.directions) {
            BlockState blockState = context.getLevel().getBlockState(context.getClickedPos().relative(side));
            if (!(blockState.getBlock() instanceof IRotate) || !((IRotate)blockState.getBlock()).hasShaftTowards((LevelReader)context.getLevel(), context.getClickedPos().relative(side), blockState, side.getOpposite())) continue;
            if (preferredSide != null && preferredSide.getAxis() != side.getAxis()) {
                preferredSide = null;
                break;
            }
            preferredSide = side;
        }
        return preferredSide;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (preferred == null || context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            Direction nearestLookingDirection = context.getNearestLookingDirection();
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? nearestLookingDirection : nearestLookingDirection.getOpposite()));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)preferred.getOpposite());
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockPos shaftPos = pos.relative((Direction)state.getValue((Property)FACING), 2);
        BlockState shaftState = level.getBlockState(shaftPos);
        if (shaftState.getBlock() instanceof ShaftBlock && shaftState.getValue((Property)RotatedPillarKineticBlock.AXIS) != ((Direction)state.getValue((Property)FACING)).getAxis()) {
            level.setBlock(shaftPos, PoweredEngineShaftBlock.getEquivalent(shaftState), 3);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (be.upgrade != EngineUpgrades.EMPTY) {
                    HugeDieselEngineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)be.upgrade.getItem());
                }
            });
            BlockPos shaftPos = pos.relative((Direction)state.getValue((Property)FACING), 2);
            BlockState shaftState = level.getBlockState(shaftPos);
            if (CDGBlocks.POWERED_ENGINE_SHAFT.has(shaftState)) {
                level.scheduleTick(shaftPos, shaftState.getBlock(), 1);
            }
        }
        if (!(!state.hasBlockEntity() || state.is(newState.getBlock()) && newState.hasBlockEntity())) {
            level.removeBlockEntity(pos);
        }
    }

    public Class<HugeDieselEngineBlockEntity> getBlockEntityClass() {
        return HugeDieselEngineBlockEntity.class;
    }

    public BlockEntityType<? extends HugeDieselEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.HUGE_DIESEL_ENGINE.get();
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.SHAFT).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.getBlock() instanceof HugeDieselEngineBlock;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction direction;
            BlockPos shaftPos = pos.relative((Direction)state.getValue((Property)FACING), 2);
            BlockState shaft = AllBlocks.SHAFT.getDefaultState();
            Direction[] directionArray = Direction.orderedByNearest((Entity)player);
            int n = directionArray.length;
            for (int i = 0; i < n && (shaft = (BlockState)shaft.setValue((Property)ShaftBlock.AXIS, (Comparable)(direction = directionArray[i]).getAxis())).getValue((Property)RotatedPillarKineticBlock.AXIS) == ((Direction)state.getValue((Property)FACING)).getAxis(); ++i) {
            }
            BlockState newState = level.getBlockState(shaftPos);
            if (!newState.canBeReplaced()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = (Direction.Axis)shaft.getValue((Property)ShaftBlock.AXIS);
            return PlacementOffset.success((Vec3i)shaftPos, s -> (BlockState)BlockHelper.copyProperties((BlockState)s, (BlockState)CDGBlocks.POWERED_ENGINE_SHAFT.getDefaultState()).setValue((Property)PoweredShaftBlock.AXIS, (Comparable)axis));
        }
    }
}

