/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.DynamicTreesHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsHandler {
    public static void tryMeltSnowUnderTrees(ServerLevel level) {
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        SeasonsConfig.SeasonProperties seasonProperties = ModConfig.seasons.getSeasonProperties(subSeason);
        float meltRandomness = seasonProperties.meltChance() / 100.0f;
        int rolls = seasonProperties.meltRolls();
        if (rolls > 0 && meltRandomness > 0.0f && SereneSeasonsHandler.generateSnowAndIce() && ModConfig.seasons.isDimensionWhitelisted(level.dimension())) {
            SnowUnderTrees.runForChunks(level, chunk -> {
                for (int i = 0; i < rolls; ++i) {
                    BlockState stateAfter;
                    BlockState stateNow;
                    Holder biomeHolder;
                    boolean biomeDisabled;
                    int chunkZ;
                    ChunkPos chunkPos;
                    int chunkX;
                    BlockPos randomPos;
                    if (!(level.random.nextFloat() < meltRandomness) || !level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, randomPos = level.getBlockRandomPos(chunkX = (chunkPos = chunk.getPos()).getMinBlockX(), 0, chunkZ = chunkPos.getMinBlockZ(), 15)).below()).is(BlockTags.LEAVES)) continue;
                    BlockPos pos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos);
                    if (SnowUnderTrees.isDynamicTreesLoaded()) {
                        if ((pos = DynamicTreesHandler.findGround((WorldGenLevel)level, pos.mutable())) == null) {
                            return;
                        }
                        if (level.getBlockState(pos).isAir()) {
                            pos = pos.below();
                        }
                    }
                    boolean bl = biomeDisabled = SnowUnderTrees.isBiomeDisabled((Holder<Biome>)(biomeHolder = level.getBiome(pos))) || biomeHolder.is(ModTags.Biomes.BLACKLISTED_BIOMES);
                    if (biomeDisabled || !SnowUnderTrees.isSnow((WorldGenLevel)level, pos) || !SeasonHooks.warmEnoughToRainSeasonal((LevelReader)level, (Holder)biomeHolder, (BlockPos)pos) || (stateNow = level.getBlockState(pos)) == (stateAfter = SnowUnderTrees.getStateAfterMelting(stateNow, (WorldGenLevel)level, pos))) continue;
                    BlockPos downPos = pos.below();
                    BlockState below = level.getBlockState(downPos);
                    level.setBlockAndUpdate(pos, stateAfter);
                    if (!below.hasProperty((Property)SnowyDirtBlock.SNOWY)) continue;
                    level.setBlock(downPos, (BlockState)below.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(false)), 2);
                }
            });
        }
    }

    public static boolean coldEnoughToSnow(WorldGenLevel level, Holder<Biome> biome, BlockPos pos) {
        return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, biome, (BlockPos)pos);
    }

    public static boolean generateSnowAndIce() {
        return ModConfig.seasons.generateSnowAndIce;
    }
}

