/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.hud;

import immersive_aircraft.client.OverlayRenderer;
import immersive_aircraft.client.hud.Colors;
import immersive_aircraft.client.hud.Indicator;
import immersive_aircraft.client.hud.StringDrawer;
import immersive_aircraft.client.hud.WarningIndicator;
import immersive_aircraft.entity.EngineVehicle;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec3;

public class AltIndicator
implements Indicator {
    public static final AltIndicator INSTANCE = new AltIndicator();
    private double lastAlt = 0.0;
    private static final int widthHalf = 100;
    private static final int bHeightHalf = 35;
    double vSpeed = 0.0;
    double iSpeed = 0.0;
    double iSpeedRt = 0.0;

    @Override
    public void update(Minecraft client, EngineVehicle aircraft) {
        this.lastAlt = aircraft.getY() - (double)aircraft.level().getSeaLevel();
        double speed = aircraft.getSpeedVector().y * 10.0;
        if (speed != this.vSpeed) {
            this.iSpeed = speed - this.vSpeed;
            this.iSpeedRt = -this.iSpeed / 30.0;
            this.vSpeed = speed;
        }
        if ((this.iSpeed + this.iSpeedRt) * this.iSpeed > 0.0) {
            this.iSpeed += this.iSpeedRt;
        } else {
            this.iSpeed = 0.0;
            this.iSpeedRt = 0.0;
        }
    }

    @Override
    public void drawDashboard(GuiGraphics context, Minecraft client, int baseX, int baseY, EngineVehicle aircraft, int color) {
        char rt = '-';
        if (this.vSpeed < -10.0) {
            rt = '\u25bc';
        } else if (this.vSpeed < -1.0) {
            rt = '\u23f7';
        } else if (this.vSpeed > 10.0) {
            rt = '\u25b2';
        } else if (this.vSpeed > 1.0) {
            rt = '\u23f6';
        }
        StringDrawer.drawString3(context, client, String.format("ALT %3.1f%s", this.lastAlt, Character.valueOf(rt)), baseX + 100 + 5, baseY, color, true);
    }

    @Override
    public void drawHUD(GuiGraphics context, Minecraft client, int baseX, int baseY, int width, EngineVehicle aircraft, int color, int[] edge) {
        for (int i = -35; i < 35; i += 5) {
            if (!this.edgeCheck(edge, 2, baseX, baseY + i * width / 100)) continue;
            OverlayRenderer.renderLine(context, baseX, baseY + i * width / 100 - 1, baseX, baseY + (i + 5) * width / 100 + 1, color);
        }
        IntStream.range(-14, 16).forEach(value -> {
            int y;
            int x = baseX + 4 - (Math.abs(value) >= 10 ? 1 : 0);
            if (this.edgeCheck(edge, 2, x, y = baseY + value * width / 40)) {
                StringDrawer.drawString6(context, client, "\u2011", x, y, color, false);
            }
        });
        if (this.edgeCheck(edge, 5, baseX, baseY)) {
            Objects.requireNonNull(client.font);
            StringDrawer.drawString4(context, client, "  ALT", baseX + 10, baseY - 9, color, false);
            StringDrawer.drawString4(context, client, String.format("-{%3.1f]", this.lastAlt), baseX, baseY, color, false);
        }
        int iz = (int)this.lastAlt;
        int nearest1_10 = Math.floorDiv(iz, 10);
        PrimitiveIterator.OfInt it = IntStream.range(nearest1_10 - 5, nearest1_10 + 6).iterator();
        while (it.hasNext()) {
            String vp;
            int v = (Integer)it.next();
            Object object = v % 10 == 0 ? (v == nearest1_10 ? "\u2500" : "\u00b7" + String.valueOf(v / 10) + "\u00b7") : (vp = v % 5 == 0 ? "\u2500" : "-");
            int yy = baseY + (iz - v * 10) * width / 100;
            if (!this.edgeCheck(edge, 5, baseX, yy)) continue;
            StringDrawer.drawString4(context, client, vp, baseX, yy, color, false);
        }
        int yr = baseY - (int)((this.vSpeed - this.iSpeed) * (double)width / 40.0);
        if (this.edgeCheck(edge, 3, baseX + 1, yr)) {
            StringDrawer.drawString6(context, client, "\u25b7", baseX + 1, yr, color, false);
        }
    }

    @Override
    public void drawDials(GuiGraphics context, Minecraft client, int baseX, int baseY, int scale, EngineVehicle aircraft) {
        context.fill(baseX - 27 * scale, baseY - 27 * scale, baseX + 27 * scale + 1, baseY + 27 * scale + 1, Colors.colorBG);
        Vec3 scale0 = new Vec3(0.0, (double)(25 * scale), 0.0);
        Vec3 scale1 = new Vec3(0.0, (double)(22 * scale), 0.0);
        Vec3 scale2 = new Vec3(0.0, (double)(20 * scale), 0.0);
        Vec3 scale3 = new Vec3(0.0, (double)(16 * scale), 0.0);
        Vec3 scale4 = new Vec3(0.0, (double)(10 * scale), 0.0);
        for (int i = 0; i < 100; i += 2) {
            float angle = -((float)Math.toRadians(3.6f * (float)i));
            Vec3 sa = scale0.zRot(angle);
            Vec3 sb = i % 10 == 0 ? scale2.zRot(angle) : scale1.zRot(angle);
            OverlayRenderer.renderLine(context, baseX + (int)sa.x, baseY + (int)sa.y, baseX + (int)sb.x, baseY + (int)sb.y, Colors.colorFG);
            if (i % 10 != 0) continue;
            Vec3 sc = scale3.zRot(angle);
            Vec3 sd = scale4.zRot(angle);
            StringDrawer.drawString5(context, client, String.valueOf(i / 10), baseX + (int)sc.x + 2, baseY + (int)sc.y - 1, Colors.colorFG, false);
            if (i % 50 == 0) {
                StringDrawer.drawString5(context, client, StringDrawer.toSubScript(String.valueOf(i / 5)), baseX + (int)sd.x + 2, baseY + (int)sd.y - 1, Colors.colorFG, false);
                continue;
            }
            StringDrawer.drawString5(context, client, StringDrawer.toSubScript(String.valueOf(i / 5 % 10)), baseX + (int)sd.x + 2, baseY + (int)sd.y - 1, Colors.colorFG, false);
        }
        float angle = -((float)Math.toRadians(this.lastAlt * (double)3.6f));
        float angle2 = -((float)Math.toRadians(Math.max(0.0, Math.min(2000.0, this.lastAlt)) * (double)0.18f));
        Vec3 h1 = scale1.zRot(angle);
        Vec3 h2 = scale3.zRot(angle2);
        OverlayRenderer.renderLine(context, baseX, baseY, baseX + (int)h1.x, baseY + (int)h1.y, Colors.colorHD1, false, true);
        OverlayRenderer.renderLine(context, baseX, baseY, baseX + (int)h2.x, baseY + (int)h2.y, Colors.colorHD2, false, true);
        OverlayRenderer.drawDialOutline(context, baseX, baseY, scale);
        if (scale > 1) {
            StringDrawer.drawString9(context, client, "ALT", baseX + 20 * scale + 1, baseY + 25 * scale + 1, Colors.colorFG, false);
        } else {
            int x = baseX + 11;
            int y = baseY + 26;
            context.fill(x, y - 4, x + 1, y, Colors.colorFG);
            context.fill(x + 1, y - 5, x + 2, y - 4, Colors.colorFG);
            context.fill(x + 2, y - 4, x + 3, y, Colors.colorFG);
            context.fill(x + 1, y - 3, x + 2, y - 2, Colors.colorFG);
            x = baseX + 14;
            y = baseY + 26;
            context.fill(x + 1, y - 5, x + 2, y - 1, Colors.colorFG);
            context.fill(x + 1, y - 1, x + 3, y, Colors.colorFG);
            x = baseX + 17;
            y = baseY + 26;
            context.fill(x, y - 5, x + 3, y - 4, Colors.colorFG);
            context.fill(x + 1, y - 4, x + 2, y, Colors.colorFG);
        }
        for (int i = -20; i <= 20; i += 2) {
            context.fill(baseX - 26 * scale, baseY + i * scale, baseX - 25 * scale, baseY + i * scale + 1, Math.abs(i) > 10 ? Colors.colorFG2 : Colors.colorBG);
        }
        StringDrawer.drawString6(context, client, "\u23f4", baseX - 25 * scale + 4, baseY - (int)(Math.max(Math.min(this.vSpeed - this.iSpeed, 20.0), -20.0) * (double)scale), Colors.colorHD1, true);
        context.fill(baseX - 3 * scale, baseY - 3 * scale, baseX + 3 * scale + 1, baseY + 3 * scale + 1, Colors.colorFG);
        context.fill(baseX - 2 * scale, baseY - 2 * scale, baseX + 2 * scale + 1, baseY + 2 * scale + 1, this.lastAlt < 0.0 || this.lastAlt >= 2000.0 || WarningIndicator.INSTANCE.cMap.get((Object)EngineVehicle.Cautions.PULL_UP) != false ? Colors.colorLt1 : Colors.colorLt0);
    }
}

