/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items.handheld_saw;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.lopyluna.dndesires.content.items.IOnBlockBreak;
import dev.lopyluna.dndesires.content.items.TreeOverride;
import dev.lopyluna.dndesires.content.items.handheld_saw.HandheldSawRenderer;
import dev.lopyluna.dndesires.mixins.AxeItemAccessor;
import dev.lopyluna.dndesires.register.DesiresItems;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class HandheldSawItem
extends AxeItem
implements CustomArmPoseItem,
IOnBlockBreak {
    private static boolean deforesting = false;

    public HandheldSawItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public void onBlockBreak(ItemStack pStack, LevelAccessor pAccessor, BlockPos pPos, BlockState pState, Player pBreaker) {
        boolean flag;
        if (!DesiresItems.HANDHELD_SAW.isIn(pStack) || !(pAccessor instanceof Level)) {
            return;
        }
        Level pLevel = (Level)pAccessor;
        boolean bl = flag = !(pBreaker instanceof FakePlayer);
        if (deforesting || !this.isValidTree(pState)) {
            return;
        }
        boolean playerHeldKey = flag ? !pBreaker.getPersistentData().getBoolean("HandheldSawKey") : false;
        if (playerHeldKey) {
            return;
        }
        Vec3 vec = pBreaker.getLookAngle();
        deforesting = true;
        Optional dynamicTree = TreeCutter.findDynamicTree((Block)pState.getBlock(), (BlockPos)pPos);
        if (dynamicTree.isPresent()) {
            ((AbstractBlockBreakQueue)dynamicTree.get()).destroyBlocks(pLevel, (LivingEntity)pBreaker, (dropPos, item) -> HandheldSawItem.dropItemFromCutTree(pLevel, pPos, vec, dropPos, item));
            deforesting = false;
            return;
        }
        new TreeOverride(TreeCutter.findTree((BlockGetter)pLevel, (BlockPos)pPos, (BlockState)pState)).destroyBlocks(pLevel, (LivingEntity)pBreaker, (dropPos, item) -> HandheldSawItem.dropItemFromCutTree(pLevel, pPos, vec, dropPos, item));
        deforesting = false;
    }

    public boolean isValidTree(BlockState pState) {
        return TreeCutter.isVerticalPlant((BlockState)pState) || TreeCutter.isChorus((BlockState)pState) || TreeCutter.isLog((BlockState)pState) || TreeCutter.isRoot((BlockState)pState);
    }

    public static void dropItemFromCutTree(Level world, BlockPos breakingPos, Vec3 fallDirection, BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.distSqr((Vec3i)breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(world, dropPos.x, dropPos.y, dropPos.z, stack);
        entity.setDeltaMovement(fallDirection.scale((double)(distance / 16.0f)));
        world.addFreshEntity((Entity)entity);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        return this.axeUseOn(context);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!BacktankUtil.canAbsorbDamage((LivingEntity)attacker, (int)HandheldSawItem.maxUses())) {
            stack.hurtAndBreak(2, attacker, EquipmentSlot.MAINHAND);
        }
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        if (tool != null) {
            if (!BacktankUtil.canAbsorbDamage((LivingEntity)miningEntity, (int)HandheldSawItem.maxUses()) && !level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f && tool.damagePerBlock() > 0) {
                stack.hurtAndBreak(tool.damagePerBlock(), miningEntity, EquipmentSlot.MAINHAND);
            }
            return true;
        }
        return false;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return state.is(BlockTags.MINEABLE_WITH_AXE) || !state.requiresCorrectToolForDrops() || state.canBeReplaced();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.getItem() != oldStack.getItem();
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)HandheldSawItem.maxUses());
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)HandheldSawItem.maxUses());
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)HandheldSawItem.maxUses());
    }

    private static int maxUses() {
        return (Integer)AllConfigs.server().equipment.maxPotatoCannonShots.get();
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        return true;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.swinging) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new HandheldSawRenderer()));
    }

    public InteractionResult axeUseOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Player player = context.getPlayer();
        if (AxeItemAccessor.playerHasShieldUseIntent(context)) {
            return InteractionResult.PASS;
        }
        Optional<BlockState> optional = this.evaluateNewBlockState(level, blockpos, player, level.getBlockState(blockpos), context);
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = context.getItemInHand();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockpos, itemstack);
        }
        level.setBlock(blockpos, optional.get(), 11);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)optional.get()));
        if (player != null) {
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private Optional<BlockState> evaluateNewBlockState(Level level, BlockPos pos, @Nullable Player player, BlockState state, UseOnContext p_40529_) {
        Optional<BlockState> optional = Optional.ofNullable(state.getToolModifiedState(p_40529_, ItemAbilities.AXE_STRIP, false));
        if (optional.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            return optional;
        }
        Optional<BlockState> optional1 = Optional.ofNullable(state.getToolModifiedState(p_40529_, ItemAbilities.AXE_SCRAPE, false));
        if (optional1.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3005, pos, 0);
            return optional1;
        }
        Optional<BlockState> optional2 = Optional.ofNullable(state.getToolModifiedState(p_40529_, ItemAbilities.AXE_WAX_OFF, false));
        if (optional2.isPresent()) {
            level.playSound(player, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3004, pos, 0);
            return optional2;
        }
        return Optional.empty();
    }
}

