/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessing;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import dev.lopyluna.dndesires.content.blocks.kinetics.industrial_fan.IndustrialFanBE;
import dev.lopyluna.dndesires.mixins.AirCurrentClientAccessor;
import dev.lopyluna.dndesires.mixins.ServerGamePacketListenerImplAccessor;
import dev.lopyluna.dndesires.register.DesiresConfigs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class IndustrialAirCurrent
extends AirCurrent {
    public IndustrialAirCurrent(IAirCurrentSource source) {
        super(source);
    }

    protected void tickAffectedEntities(Level level) {
        Iterator iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            FanProcessingType processingType;
            Entity entity = (Entity)iterator.next();
            if (!entity.isAlive() || !entity.getBoundingBox().intersects(this.bounds) || IndustrialAirCurrent.isPlayerCreativeFlying((Entity)entity)) {
                iterator.remove();
                continue;
            }
            Vec3i flow = (this.pushing ? this.direction : this.direction.getOpposite()).getNormal();
            float speed = Math.abs(this.source.getSpeed());
            float sneakModifier = entity.isShiftKeyDown() ? 4096.0f : 512.0f;
            double entityDistance = VecHelper.alignedDistanceToFace((Vec3)entity.position(), (BlockPos)this.source.getAirCurrentPos(), (Direction)this.direction);
            double entityDistanceOld = entity.position().distanceTo(VecHelper.getCenterOf((Vec3i)this.source.getAirCurrentPos()));
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistanceOld / (double)this.maxDistance));
            Vec3 previousMotion = entity.getDeltaMovement();
            int maxAcceleration = 5;
            double xIn = Mth.clamp((double)((double)((float)flow.getX() * acceleration) - previousMotion.x), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = Mth.clamp((double)((double)((float)flow.getY() * acceleration) - previousMotion.y), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = Mth.clamp((double)((double)((float)flow.getZ() * acceleration) - previousMotion.z), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.setDeltaMovement(previousMotion.add(new Vec3(xIn, yIn, zIn).scale(0.125)));
            entity.fallDistance = 0.0f;
            if (CatnipServices.PLATFORM.getEnv().isClient()) {
                AirCurrentClientAccessor.enableClientPlayerSound(entity, Mth.clamp((float)(speed / 128.0f * 0.4f), (float)0.01f, (float)0.4f));
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ((ServerGamePacketListenerImplAccessor)serverPlayer.connection).aboveGroundTickCount(0);
            }
            if ((processingType = this.getTypeAt((float)entityDistance)) == null) continue;
            if (entity instanceof ItemEntity) {
                IAirCurrentSource iAirCurrentSource;
                ItemEntity itemEntity = (ItemEntity)entity;
                if (level != null && level.isClientSide) {
                    processingType.spawnProcessingParticles(level, entity.position());
                    continue;
                }
                if (!FanProcessing.canProcess((ItemEntity)itemEntity, (FanProcessingType)processingType) || !IndustrialAirCurrent.applyProcessing(itemEntity, level, processingType) || !((iAirCurrentSource = this.source) instanceof IndustrialFanBE)) continue;
                IndustrialFanBE fan = (IndustrialFanBE)iAirCurrentSource;
                fan.award(AllAdvancements.FAN_PROCESSING);
                continue;
            }
            if (level == null) continue;
            processingType.affectEntity(entity, level);
        }
    }

    public void tickAffectedHandlers() {
        for (Pair pair : this.affectedItemHandlers) {
            TransportedItemStackHandlerBehaviour handler = (TransportedItemStackHandlerBehaviour)pair.getKey();
            Level level = handler.getWorld();
            FanProcessingType processingType = (FanProcessingType)pair.getRight();
            if (processingType == null) continue;
            handler.handleProcessingOnAllItems(transported -> {
                IAirCurrentSource patt0$temp;
                if (level.isClientSide) {
                    processingType.spawnProcessingParticles(level, handler.getWorldPositionOf(transported));
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing = IndustrialAirCurrent.applyProcessing(transported, level, processingType);
                if (!applyProcessing.doesNothing() && (patt0$temp = this.source) instanceof IndustrialFanBE) {
                    IndustrialFanBE fan = (IndustrialFanBE)patt0$temp;
                    fan.award(AllAdvancements.FAN_PROCESSING);
                }
                return applyProcessing;
            });
        }
    }

    public static boolean applyProcessing(ItemEntity entity, Level level, FanProcessingType type) {
        if (IndustrialAirCurrent.decrementProcessingTime(entity, type) != 0) {
            return false;
        }
        List stacks = type.process(entity.getItem(), level);
        if (stacks == null) {
            return false;
        }
        if (stacks.isEmpty()) {
            entity.discard();
            return false;
        }
        entity.setItem((ItemStack)stacks.removeFirst());
        for (ItemStack additional : stacks) {
            ItemEntity entityIn = new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), additional);
            entityIn.setDeltaMovement(entity.getDeltaMovement());
            level.addFreshEntity((Entity)entityIn);
        }
        return true;
    }

    public static TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing(TransportedItemStack transported, Level level, FanProcessingType type) {
        TransportedItemStackHandlerBehaviour.TransportedResult ignore = TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        if (transported.processedBy != type) {
            transported.processedBy = type;
            int timeModifierForStackSize = (transported.stack.getCount() - 1) / 16 + 1;
            transported.processingTime = (Integer)DesiresConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
            if (!type.canProcess(transported.stack, level)) {
                transported.processingTime = -1;
            }
            return ignore;
        }
        if (transported.processingTime == -1) {
            return ignore;
        }
        if (transported.processingTime-- > 0) {
            return ignore;
        }
        List stacks = type.process(transported.stack, level);
        if (stacks == null) {
            return ignore;
        }
        ArrayList<TransportedItemStack> transportedStacks = new ArrayList<TransportedItemStack>();
        for (ItemStack additional : stacks) {
            TransportedItemStack newTransported = transported.getSimilar();
            newTransported.stack = additional.copy();
            transportedStacks.add(newTransported);
        }
        return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedStacks);
    }

    private static int decrementProcessingTime(ItemEntity entity, FanProcessingType type) {
        CompoundTag processing;
        CompoundTag createData;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.contains("CreateData")) {
            nbt.put("CreateData", (Tag)new CompoundTag());
        }
        if (!(createData = nbt.getCompound("CreateData")).contains("Processing")) {
            createData.put("Processing", (Tag)new CompoundTag());
        }
        if (!(processing = createData.getCompound("Processing")).contains("Type") || AllFanProcessingTypes.parseLegacy((String)processing.getString("Type")) != type) {
            ResourceLocation key = CreateBuiltInRegistries.FAN_PROCESSING_TYPE.getKey((Object)type);
            if (key == null) {
                throw new IllegalArgumentException("Could not get id for FanProcessingType " + String.valueOf(type) + "!");
            }
            processing.putString("Type", key.toString());
            int timeModifierForStackSize = (entity.getItem().getCount() - 1) / 16 + 1;
            int processingTime = (Integer)DesiresConfigs.server().kinetics.fanProcessingTime.get() * timeModifierForStackSize + 1;
            processing.putInt("Time", processingTime);
        }
        int value = processing.getInt("Time") - 1;
        processing.putInt("Time", value);
        return value;
    }
}

