/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.gameTests;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.JUnitLikeTestReporter;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.gametest.framework.TestReporter;
import net.minecraft.world.level.block.Rotation;
import xyz.faewulf.lib.platform.Services;
import xyz.faewulf.lib.util.gameTests.Modifier;
import xyz.faewulf.lib.util.gameTests.TestGroup;

public class registerGameTests {
    public static List<String> paths = new ArrayList<String>();

    @GameTestGenerator
    public static List<TestFunction> getTests() {
        ArrayList<TestFunction> functions = new ArrayList<TestFunction>();
        paths.add("xyz.faewulf.lib.util.gameTests.entry");
        try {
            for (String path : paths) {
                List<Class<?>> testClassList = Services.PLATFORM.findClasses(path);
                testClassList.forEach(aClass -> {
                    if (aClass.isAnnotationPresent(TestGroup.class)) {
                        String[] pkgFullPath = aClass.getPackage().getName().split("\\.");
                        String pkgName = "";
                        if (pkgFullPath.length > 0) {
                            pkgName = pkgFullPath[pkgFullPath.length - 1];
                        }
                        for (Method method : aClass.getDeclaredMethods()) {
                            if (!method.isAnnotationPresent(GameTest.class)) continue;
                            GameTest annotation = method.getAnnotation(GameTest.class);
                            String className = aClass.getSimpleName().toLowerCase();
                            String testName = pkgName + "." + className + "." + method.getName().toLowerCase();
                            Object template = annotation.template().isEmpty() ? testName : annotation.template();
                            Rotation rotation = StructureUtils.getRotationForRotationSteps((int)annotation.rotationSteps());
                            ModifingConsumer consumer = new ModifingConsumer((Class<?>)aClass, method, Modifier.from(method));
                            functions.add(new TestFunction(annotation.batch(), testName, (String)template, rotation, annotation.timeoutTicks(), annotation.setupTicks(), annotation.required(), annotation.manualOnly(), annotation.attempts(), annotation.requiredSuccesses(), annotation.skyAccess(), (Consumer)consumer));
                        }
                    }
                });
            }
            if (!functions.isEmpty()) {
                try {
                    GlobalTestReporter.replaceWith((TestReporter)new JUnitLikeTestReporter(new File("game-test-results.xml")));
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
            return functions;
        }
        catch (IllegalArgumentException a) {
            return new ArrayList<TestFunction>();
        }
    }

    public static class ModifingConsumer
    implements Consumer<GameTestHelper> {
        private final Class<?> testClass;
        private final Method testMethod;
        private final Modifier modifier;

        public ModifingConsumer(Class<?> testClass, Method testMethod, Modifier modifier) {
            this.testClass = testClass;
            this.testMethod = testMethod;
            this.modifier = modifier;
        }

        @Override
        public void accept(GameTestHelper gameTestHelper) {
            Object instance;
            try {
                instance = this.testClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error while creating test class " + String.valueOf(this.testClass), e.getCause());
            }
            try {
                this.testMethod.invoke(instance, gameTestHelper);
                if (this.modifier.isImplicitSuccession()) {
                    gameTestHelper.succeed();
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(this.testMethod.getName(), this.testMethod.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }
}

