/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockUtils {
    public static void breakBlockWithDrops(Level level, BlockPos pos, @Nullable Player player) {
        BlockState state = level.getBlockState(pos);
        if (player != null) {
            level.destroyBlock(pos, true, (Entity)player);
            state.getBlock().playerWillDestroy(level, pos, state, player);
        } else {
            level.destroyBlock(pos, true);
        }
    }

    public static void replaceBlock(ServerLevel level, @NotNull BlockState blockState, BlockPos blockPos, boolean breakEffect) {
        if (breakEffect) {
            level.setBlock(blockPos, blockState, 3);
        } else {
            level.setBlockAndUpdate(blockPos, blockState);
        }
    }

    public static boolean canPlaceOn(ServerLevel level, @NotNull BlockState blockState, BlockPos blockPos) {
        return blockState.canSurvive((LevelReader)level, blockPos);
    }
}

