/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;

public class WillowTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<WillowTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(willowTrunkPlacerInstance -> WillowTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)willowTrunkPlacerInstance).apply((Applicative)willowTrunkPlacerInstance, WillowTrunkPlacer::new));

    public WillowTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)TrunkPlacerTypeRegistration.WILLOW_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> biConsumer, RandomSource randomSource, int freeTreeHeight, BlockPos pPos, TreeConfiguration treeConfiguration) {
        WillowTrunkPlacer.setDirtAt((LevelSimulatedReader)pLevel, biConsumer, (RandomSource)randomSource, (BlockPos)pPos.below(), (TreeConfiguration)treeConfiguration);
        ArrayList<FoliagePlacer.FoliageAttachment> foliageSpots = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int maxHeight = this.baseHeight + randomSource.nextInt(this.heightRandA, this.heightRandB + 1);
        int xOffset = 0;
        int zOffset = 0;
        List<Integer> sideHeights = List.of(Integer.valueOf(randomSource.nextInt(0, 4)), Integer.valueOf(randomSource.nextInt(0, 4)), Integer.valueOf(randomSource.nextInt(0, 4)), Integer.valueOf(randomSource.nextInt(0, 4)), Integer.valueOf(randomSource.nextInt(0, 4)), Integer.valueOf(randomSource.nextInt(0, 4)), Integer.valueOf(randomSource.nextInt(0, 4)), Integer.valueOf(randomSource.nextInt(0, 4)));
        BlockPos nextPos = pPos;
        this.placeLog(pLevel, biConsumer, randomSource, pPos, treeConfiguration);
        for (int i = 0; i < maxHeight; ++i) {
            if (randomSource.nextFloat() > 0.85f) {
                zOffset += randomSource.nextInt(-1, 1);
            }
            if (randomSource.nextFloat() > 0.85f) {
                xOffset += randomSource.nextInt(-1, 1);
            }
            nextPos = new BlockPos(pPos.getX() + xOffset, pPos.getY() + i, pPos.getZ() + zOffset);
            this.placeLog(pLevel, biConsumer, randomSource, nextPos, treeConfiguration);
            this.placeLog(pLevel, biConsumer, randomSource, nextPos.below(), treeConfiguration);
            if (i - 2 <= sideHeights.get(0) || i >= maxHeight - sideHeights.get(4)) {
                this.placeLog(pLevel, biConsumer, randomSource, nextPos.north(), treeConfiguration);
            }
            if (i - 2 <= sideHeights.get(1) || i >= maxHeight - sideHeights.get(5)) {
                this.placeLog(pLevel, biConsumer, randomSource, nextPos.east(), treeConfiguration);
            }
            if (i - 2 <= sideHeights.get(2) || i >= maxHeight - sideHeights.get(6)) {
                this.placeLog(pLevel, biConsumer, randomSource, nextPos.south(), treeConfiguration);
            }
            if (i - 2 > sideHeights.get(3) && i < maxHeight - sideHeights.get(7)) continue;
            this.placeLog(pLevel, biConsumer, randomSource, nextPos.west(), treeConfiguration);
        }
        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
        int branchNumber = randomSource.nextInt(3, 8);
        BlockPos pastPos = nextPos;
        for (int j = 1; j <= branchNumber; ++j) {
            nextPos = pastPos;
            int branchMaxBlocks = (int)((float)maxHeight * ((float)randomSource.nextInt(60, 90) / 100.0f)) + randomSource.nextInt(-2, 5);
            int branchAngle = (int)(360.0f / (float)branchNumber) * j + randomSource.nextInt(-15, 16);
            if (branchAngle < 0) {
                branchAngle += 360;
            } else if (branchAngle >= 360) {
                branchAngle -= 360;
            }
            BlockState logDirection = (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X);
            if (branchAngle > 45 && branchAngle <= 135 || branchAngle < 315 && branchAngle >= 225) {
                logDirection = (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z);
            }
            BlockState pastLogDirection = logDirection;
            boolean wentDown = false;
            if (branchAngle < 90) {
                k = 0;
                while (k < branchMaxBlocks) {
                    logDirection = pastLogDirection;
                    if (k % 2 == 0 || wentDown) {
                        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
                    }
                    wentDown = false;
                    nextPos = randomSource.nextFloat() > (float)branchAngle / 90.0f ? nextPos.east() : nextPos.north();
                    if (randomSource.nextFloat() < (float)k / ((float)branchMaxBlocks * (float)(1 + randomSource.nextInt(0, 2)))) {
                        nextPos = nextPos.below();
                        logDirection = (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y);
                        wentDown = true;
                    }
                    biConsumer.accept(nextPos, (BlockState)Function.identity().apply(logDirection));
                    ++k;
                    if (!wentDown) continue;
                    biConsumer.accept(nextPos.above(), (BlockState)Function.identity().apply(logDirection));
                    ++k;
                }
            } else if (branchAngle < 180) {
                k = 0;
                while (k < branchMaxBlocks) {
                    logDirection = pastLogDirection;
                    if (k % 2 == 0 || wentDown) {
                        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
                    }
                    wentDown = false;
                    nextPos = randomSource.nextFloat() > (float)(branchAngle - 90) / 90.0f ? nextPos.south() : nextPos.east();
                    if (randomSource.nextFloat() < (float)k / ((float)branchMaxBlocks * (float)(1 + randomSource.nextInt(0, 2)))) {
                        nextPos = nextPos.below();
                        logDirection = (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y);
                        wentDown = true;
                    }
                    biConsumer.accept(nextPos, (BlockState)Function.identity().apply(logDirection));
                    ++k;
                    if (!wentDown) continue;
                    biConsumer.accept(nextPos.above(), (BlockState)Function.identity().apply(logDirection));
                    ++k;
                }
            } else if (branchAngle < 270) {
                k = 0;
                while (k < branchMaxBlocks) {
                    logDirection = pastLogDirection;
                    if (k % 2 == 0 || wentDown) {
                        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
                    }
                    wentDown = false;
                    nextPos = randomSource.nextFloat() > (float)(branchAngle - 180) / 90.0f ? nextPos.west() : nextPos.south();
                    if (randomSource.nextFloat() < (float)k / ((float)branchMaxBlocks * (float)(1 + randomSource.nextInt(0, 2)))) {
                        nextPos = nextPos.below();
                        logDirection = (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y);
                        wentDown = true;
                    }
                    biConsumer.accept(nextPos, (BlockState)Function.identity().apply(logDirection));
                    ++k;
                    if (!wentDown) continue;
                    biConsumer.accept(nextPos.above(), (BlockState)Function.identity().apply(logDirection));
                    ++k;
                }
            } else {
                k = 0;
                while (k < branchMaxBlocks) {
                    logDirection = pastLogDirection;
                    if (k % 2 == 0 || wentDown) {
                        foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
                    }
                    wentDown = false;
                    nextPos = randomSource.nextFloat() > (float)(branchAngle - 270) / 90.0f ? nextPos.north() : nextPos.west();
                    if (randomSource.nextFloat() < (float)k / ((float)branchMaxBlocks * (float)(1 + randomSource.nextInt(0, 2)))) {
                        nextPos = nextPos.below();
                        logDirection = (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y);
                        wentDown = true;
                    }
                    biConsumer.accept(nextPos, (BlockState)Function.identity().apply(logDirection));
                    ++k;
                    if (!wentDown) continue;
                    biConsumer.accept(nextPos.above(), (BlockState)Function.identity().apply(logDirection));
                    ++k;
                }
            }
            foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
        }
        return foliageSpots;
    }
}

