/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.redchujelly.cluttered.block.custom.WillowVinesBlock;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.setup.TreeDecoratorTypeRegistration;

public class WillowTreeDecorator
extends TreeDecorator {
    public static final MapCodec<WillowTreeDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(WillowTreeDecorator::new, willowTreeDecoratorInstance -> Float.valueOf(willowTreeDecoratorInstance.probability));
    private final float probability;

    public WillowTreeDecorator(float probability) {
        this.probability = probability;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)TreeDecoratorTypeRegistration.WILLOW_TREE_DECORATOR.get();
    }

    public void place(TreeDecorator.Context pContext) {
        RandomSource randomsource = pContext.random();
        for (BlockPos leafPos : pContext.leaves()) {
            if (!pContext.isAir(leafPos.below()) || !(randomsource.nextFloat() < this.probability)) continue;
            int strandLength = randomsource.nextInt(4, 8);
            if (randomsource.nextBoolean()) {
                strandLength -= 4;
            }
            int i = 0;
            while (i < strandLength && pContext.isAir(leafPos.below(++i))) {
                pContext.setBlock(leafPos.below(i), (BlockState)((BlockState)((Block)BlockRegistration.WILLOW_VINES.get()).defaultBlockState().setValue((Property)WillowVinesBlock.GRADIENT, (Comparable)Integer.valueOf(Math.min(i, 6)))).setValue((Property)WillowVinesBlock.BOTTOM, (Comparable)Boolean.valueOf(i == strandLength)));
            }
        }
    }
}

