/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class WillowFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<WillowFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(willowFoliagePlacerInstance -> WillowFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)willowFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).and((App)Codec.intRange((int)0, (int)10).fieldOf("length").forGetter(fp -> fp.length)).apply((Applicative)willowFoliagePlacerInstance, WillowFoliagePlacer::new));
    private final int height;
    private final int length;

    public WillowFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height, int length) {
        super(pRadius, pOffset);
        this.height = height;
        this.length = length;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.WILLOW_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int i, FoliagePlacer.FoliageAttachment foliageAttachment, int i1, int i2, int i3) {
        BlockPos base = foliageAttachment.pos().above();
        this.placeLeavesRow(pLevel, foliageSetter, randomSource, treeConfiguration, base, 1, 0, foliageAttachment.doubleTrunk());
        List<BlockPos> posList = List.of(base.north(), base.north().west(), base.south(), base.south().west(), base.east(), base.north().east(), base.west(), base.south().east());
        boolean longStrand = true;
        block0: for (BlockPos pos : posList) {
            int strandLength;
            if (longStrand) {
                strandLength = this.length + randomSource.nextInt(-2, 1);
                longStrand = false;
            } else {
                strandLength = this.length + randomSource.nextInt(-8, -4);
                longStrand = true;
            }
            for (int j = 0; j < strandLength; ++j) {
                if (j == 1) {
                    if (longStrand && (double)randomSource.nextFloat() > 0.2) {
                        WillowFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)pos.above());
                    } else if (!longStrand && (double)randomSource.nextFloat() > 0.68) {
                        WillowFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)pos.above());
                    }
                }
                if (pLevel.isStateAtPosition(pos.below(j), (Predicate)BlockStatePredicate.forBlock((Block)((Block)BlockRegistration.WILLOW_LOG.get())))) continue block0;
                WillowFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)pLevel, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)pos.below(j));
            }
        }
    }

    public int foliageHeight(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource randomSource, int i, int i1, int i2, int i3, boolean b) {
        return false;
    }
}

