/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;

public class MapleTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<MapleTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(mapleTrunkPlacerInstance -> MapleTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)mapleTrunkPlacerInstance).apply((Applicative)mapleTrunkPlacerInstance, MapleTrunkPlacer::new));

    public MapleTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)TrunkPlacerTypeRegistration.MAPLE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        MapleTrunkPlacer.setDirtAt((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.below(), (TreeConfiguration)pConfig);
        List<Direction> directions = List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int maxHeight = this.baseHeight + pRandom.nextInt(this.heightRandA, this.heightRandB + 1);
        int stumpHeight = pRandom.nextInt(2, 3);
        int branchHeight1 = pRandom.nextInt(2, 5);
        int branchHeight2 = branchHeight1 + pRandom.nextInt(1, 3);
        int branchHeight3 = branchHeight2 + pRandom.nextInt(2, 4);
        int tempHeight = branchHeight1;
        int roots = 2;
        if (pRandom.nextBoolean()) {
            ++roots;
        }
        for (int r = 0; r < roots; ++r) {
            Direction cardinal = directions.get(pRandom.nextInt(0, 4));
            int amount = pRandom.nextIntBetweenInclusive(-1, 1);
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.relative(cardinal).relative(cardinal.getClockWise(), amount), pConfig);
        }
        for (int s = 0; s < stumpHeight; ++s) {
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(s), pConfig);
        }
        pPos = pPos.above(stumpHeight - 1);
        for (int i = 1; i <= maxHeight; ++i) {
            BlockState log;
            int j;
            int branchLength;
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(i), pConfig);
            if (i == tempHeight) {
                foliageAttachments.add(new FoliagePlacer.FoliageAttachment(pPos.above(branchHeight1 - 2), 0, false));
                branchLength = 4;
                for (Direction direction : directions) {
                    tempHeight = branchHeight1;
                    if (pRandom.nextFloat() < 0.25f) {
                        --branchLength;
                    }
                    for (j = 1; !(j > branchLength || j == 1 && (double)pRandom.nextFloat() < 0.1); ++j) {
                        if (j == branchLength) {
                            ++tempHeight;
                        }
                        log = (BlockState)pConfig.trunkProvider.getState(pRandom, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis());
                        pBlockSetter.accept(pPos.above(tempHeight).relative(direction, j), (BlockState)Function.identity().apply(log));
                    }
                }
            }
            if (i + 1 == branchHeight2) {
                branchLength = pRandom.nextInt(2, 4);
                for (Direction direction : directions) {
                    tempHeight = branchHeight2;
                    if (pRandom.nextFloat() < 0.25f) {
                        --branchLength;
                    }
                    for (j = 1; !(j > branchLength || j == 1 && (double)pRandom.nextFloat() < 0.1); ++j) {
                        if (j == branchLength) {
                            ++tempHeight;
                        }
                        log = (BlockState)pConfig.trunkProvider.getState(pRandom, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis());
                        pBlockSetter.accept(pPos.above(tempHeight).relative(direction, j), (BlockState)Function.identity().apply(log));
                    }
                }
            }
            if (i + 1 != branchHeight3) continue;
            branchLength = 1;
            for (Direction direction : directions) {
                tempHeight = branchHeight3;
                for (j = 1; !(j > branchLength || j == 1 && (double)pRandom.nextFloat() < 0.1); ++j) {
                    if (j == branchLength) {
                        ++tempHeight;
                    }
                    log = (BlockState)pConfig.trunkProvider.getState(pRandom, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis());
                    pBlockSetter.accept(pPos.above(tempHeight).relative(direction, j), (BlockState)Function.identity().apply(log));
                }
            }
        }
        return foliageAttachments;
    }
}

