/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class CrabappleFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CrabappleFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(crabappleFoliagePlacerInstance -> CrabappleFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)crabappleFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)crabappleFoliagePlacerInstance, CrabappleFoliagePlacer::new));
    private final int height;

    public CrabappleFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    public int foliageHeight(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.CRABAPPLE_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        for (int i = 0; i < this.height; ++i) {
            if (i == 0) {
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().above(), 1, -i, pAttachment.doubleTrunk());
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().above(), 1, 1, pAttachment.doubleTrunk());
                continue;
            }
            if (i < 2) {
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().above(), 2, -i, pAttachment.doubleTrunk());
                continue;
            }
            if (i != this.height - 1) continue;
            this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().above(), 1, -i, pAttachment.doubleTrunk());
        }
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        double distance = Math.sqrt(Math.pow(pLocalX, 2.0) + Math.pow(pLocalZ, 2.0));
        if (pLocalY == 0) {
            return pLocalX == pLocalZ && pLocalX == pRange && pRandom.nextBoolean();
        }
        if (pLocalY == 1) {
            return pLocalX == pLocalZ && pLocalX == pRange || pRandom.nextFloat() < 0.14f;
        }
        return distance > (double)pRange;
    }
}

