/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.worldgen.tree.custom.BlueMushroomFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.CrabappleFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.CrabappleTrunkPlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.MapleFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.MapleTrunkPlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.PoplarFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.RedMushroomFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.RedMushroomTrunkPlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.SycamoreFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.SycamoreTrunkPlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.WillowFoliagePlacer;
import net.redchujelly.cluttered.worldgen.tree.custom.WillowTreeDecorator;
import net.redchujelly.cluttered.worldgen.tree.custom.WillowTrunkPlacer;

public class ClutteredConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILLOW_KEY = ClutteredConfiguredFeatures.registerKey("willow");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POPLAR_KEY = ClutteredConfiguredFeatures.registerKey("poplar");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_MUSHROOM_KEY = ClutteredConfiguredFeatures.registerKey("blue_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_MUSHROOM_KEY = ClutteredConfiguredFeatures.registerKey("red_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CRABAPPLE_KEY = ClutteredConfiguredFeatures.registerKey("crabapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SYCAMORE_KEY = ClutteredConfiguredFeatures.registerKey("sycamore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAPLE_KEY = ClutteredConfiguredFeatures.registerKey("fluorescent_maple");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ClutteredConfiguredFeatures.register(context, WILLOW_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)BlockRegistration.WILLOW_LOG.get()).defaultBlockState(), 1).add((Object)((Block)BlockRegistration.FLOWERING_WILLOW_LOG.get()).defaultBlockState(), 1).build()), (TrunkPlacer)new WillowTrunkPlacer(6, 2, 6), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)BlockRegistration.WILLOW_LEAVES.get()).defaultBlockState(), 3).add((Object)((Block)BlockRegistration.FLOWERING_WILLOW_LEAVES.get()).defaultBlockState(), 2).build()), (FoliagePlacer)new WillowFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)1), 1, 5), (FeatureSize)new TwoLayersFeatureSize(5, 2, 4)).decorators(List.of(new WillowTreeDecorator(0.6f))).build());
        ClutteredConfiguredFeatures.register(context, POPLAR_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)BlockRegistration.POPLAR_LOG.get()).defaultBlockState(), 1).add((Object)((Block)BlockRegistration.FLOWERING_POPLAR_LOG.get()).defaultBlockState(), 1).build()), (TrunkPlacer)new StraightTrunkPlacer(6, 1, 3), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)BlockRegistration.POPLAR_LEAVES.get()).defaultBlockState(), 3).add((Object)((Block)BlockRegistration.FLOWERING_POPLAR_LEAVES.get()).defaultBlockState(), 2).build()), (FoliagePlacer)new PoplarFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)5), 8), (FeatureSize)new TwoLayersFeatureSize(3, 0, 2)).build());
        ClutteredConfiguredFeatures.register(context, BLUE_MUSHROOM_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistration.BLUE_MUSHROOM_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(5, 1, 3), (BlockStateProvider)WeightedStateProvider.simple((Block)((Block)BlockRegistration.BLUE_MUSHROOM_CAP.get())), (FoliagePlacer)new BlueMushroomFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)4), 3), (FeatureSize)new TwoLayersFeatureSize(5, 0, 4)).build());
        ClutteredConfiguredFeatures.register(context, RED_MUSHROOM_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistration.RED_MUSHROOM_LOG.get())), (TrunkPlacer)new RedMushroomTrunkPlacer(6, 0, 2), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistration.RED_MUSHROOM_CAP.get())), (FoliagePlacer)new RedMushroomFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)4), 5), (FeatureSize)new TwoLayersFeatureSize(4, 1, 3)).build());
        ClutteredConfiguredFeatures.register(context, CRABAPPLE_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)BlockRegistration.CRABAPPLE_LOG.get()).defaultBlockState(), 1).add((Object)((Block)BlockRegistration.FLOWERING_CRABAPPLE_LOG.get()).defaultBlockState(), 1).build()), (TrunkPlacer)new CrabappleTrunkPlacer(4, 0, 2), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)BlockRegistration.CRABAPPLE_LEAVES.get()).defaultBlockState(), 2).add((Object)((Block)BlockRegistration.FLOWERING_CRABAPPLE_LEAVES.get()).defaultBlockState(), 5).build()), (FoliagePlacer)new CrabappleFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)3), 3), (FeatureSize)new TwoLayersFeatureSize(4, 0, 3)).build());
        ClutteredConfiguredFeatures.register(context, SYCAMORE_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistration.SYCAMORE_LOG.get())), (TrunkPlacer)new SycamoreTrunkPlacer(6, 0, 4), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistration.SYCAMORE_LEAVES.get())), (FoliagePlacer)new SycamoreFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)4), 6), (FeatureSize)new TwoLayersFeatureSize(4, 0, 3)).build());
        ClutteredConfiguredFeatures.register(context, MAPLE_KEY, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlockRegistration.MAPLE_LOG.get())), (TrunkPlacer)new MapleTrunkPlacer(6, 1, 3), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((Block)BlockRegistration.MAPLE_LEAVES.get()).defaultBlockState(), 25).add((Object)((Block)BlockRegistration.MAPLE_LEAVES_FLOWERING.get()).defaultBlockState(), 5).build()), (FoliagePlacer)new MapleFoliagePlacer((IntProvider)ConstantInt.of((int)4), (IntProvider)ConstantInt.of((int)5)), (FeatureSize)new TwoLayersFeatureSize(4, 0, 3)).build());
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

