/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.redchujelly.cluttered.block.custom.BracketBlock;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;
import net.redchujelly.cluttered.setup.BlockRegistration;

public class HandDrillItem
extends Item {
    private static final Map<Holder<Block>, Holder<Block>> BLOCK_CYCLE_MAP = new HashMap<Holder<Block>, Holder<Block>>(){
        {
            this.put(BlockRegistration.WILLOW_BOOKSHELF_BLACK_CAT, BlockRegistration.WILLOW_BOOKSHELF_CALICO_CAT);
            this.put(BlockRegistration.WILLOW_BOOKSHELF_CALICO_CAT, BlockRegistration.WILLOW_BOOKSHELF_BOTTLES);
            this.put(BlockRegistration.WILLOW_BOOKSHELF_BOTTLES, BlockRegistration.WILLOW_BOOKSHELF_VASE);
            this.put(BlockRegistration.WILLOW_BOOKSHELF_VASE, BlockRegistration.WILLOW_BOOKSHELF_COBWEB);
            this.put(BlockRegistration.WILLOW_BOOKSHELF_COBWEB, BlockRegistration.WILLOW_BOOKSHELF_BLACK_CAT);
            this.put(BlockRegistration.CHALCEDONY_PILLAR, BlockRegistration.CHALCEDONY_PILLAR_BASE);
            this.put(BlockRegistration.CHALCEDONY_PILLAR_BASE, BlockRegistration.CHALCEDONY_PILLAR_DORIC);
            this.put(BlockRegistration.CHALCEDONY_PILLAR_DORIC, BlockRegistration.CHALCEDONY_PILLAR_IONIC);
            this.put(BlockRegistration.CHALCEDONY_PILLAR_IONIC, BlockRegistration.CHALCEDONY_PILLAR);
            this.put(BlockRegistration.DEEP_CHALCEDONY_PILLAR, BlockRegistration.DEEP_CHALCEDONY_PILLAR_BASE);
            this.put(BlockRegistration.DEEP_CHALCEDONY_PILLAR_BASE, BlockRegistration.DEEP_CHALCEDONY_PILLAR_DORIC);
            this.put(BlockRegistration.DEEP_CHALCEDONY_PILLAR_DORIC, BlockRegistration.DEEP_CHALCEDONY_PILLAR_IONIC);
            this.put(BlockRegistration.DEEP_CHALCEDONY_PILLAR_IONIC, BlockRegistration.DEEP_CHALCEDONY_PILLAR);
            this.put(BlockRegistration.STARRY_CHALCEDONY_PILLAR, BlockRegistration.STARRY_CHALCEDONY_PILLAR_BASE);
            this.put(BlockRegistration.STARRY_CHALCEDONY_PILLAR_BASE, BlockRegistration.STARRY_CHALCEDONY_PILLAR_DORIC);
            this.put(BlockRegistration.STARRY_CHALCEDONY_PILLAR_DORIC, BlockRegistration.STARRY_CHALCEDONY_PILLAR_IONIC);
            this.put(BlockRegistration.STARRY_CHALCEDONY_PILLAR_IONIC, BlockRegistration.STARRY_CHALCEDONY_PILLAR);
            this.put(BlockRegistration.DEEP_STARRY_CHALCEDONY_PILLAR, BlockRegistration.DEEP_STARRY_CHALCEDONY_PILLAR_BASE);
            this.put(BlockRegistration.DEEP_STARRY_CHALCEDONY_PILLAR_BASE, BlockRegistration.DEEP_STARRY_CHALCEDONY_PILLAR_DORIC);
            this.put(BlockRegistration.DEEP_STARRY_CHALCEDONY_PILLAR_DORIC, BlockRegistration.DEEP_STARRY_CHALCEDONY_PILLAR_IONIC);
            this.put(BlockRegistration.DEEP_STARRY_CHALCEDONY_PILLAR_IONIC, BlockRegistration.DEEP_STARRY_CHALCEDONY_PILLAR);
            this.put(BlockRegistration.MARBLE_PILLAR, BlockRegistration.MARBLE_PILLAR_BASE);
            this.put(BlockRegistration.MARBLE_PILLAR_BASE, BlockRegistration.MARBLE_PILLAR_DORIC);
            this.put(BlockRegistration.MARBLE_PILLAR_DORIC, BlockRegistration.MARBLE_PILLAR_IONIC);
            this.put(BlockRegistration.MARBLE_PILLAR_IONIC, BlockRegistration.MARBLE_PILLAR);
            this.put(BlockRegistration.COLOSSEO_PILLAR, BlockRegistration.COLOSSEO_PILLAR_BASE);
            this.put(BlockRegistration.COLOSSEO_PILLAR_BASE, BlockRegistration.COLOSSEO_PILLAR_TOP);
            this.put(BlockRegistration.COLOSSEO_PILLAR_TOP, BlockRegistration.COLOSSEO_PILLAR);
            this.put(BlockRegistration.CHALCEDONY_BORDER, BlockRegistration.CHALCEDONY_ACANTHUS);
            this.put(BlockRegistration.CHALCEDONY_ACANTHUS, BlockRegistration.CHALCEDONY_HELIX);
            this.put(BlockRegistration.CHALCEDONY_HELIX, BlockRegistration.CHALCEDONY_MEANDER);
            this.put(BlockRegistration.CHALCEDONY_MEANDER, BlockRegistration.CHALCEDONY_TEXTILES);
            this.put(BlockRegistration.CHALCEDONY_TEXTILES, BlockRegistration.CHALCEDONY_BORDER);
            this.put(BlockRegistration.DEEP_CHALCEDONY_BORDER, BlockRegistration.DEEP_CHALCEDONY_ACANTHUS);
            this.put(BlockRegistration.DEEP_CHALCEDONY_ACANTHUS, BlockRegistration.DEEP_CHALCEDONY_HELIX);
            this.put(BlockRegistration.DEEP_CHALCEDONY_HELIX, BlockRegistration.DEEP_CHALCEDONY_MEANDER);
            this.put(BlockRegistration.DEEP_CHALCEDONY_MEANDER, BlockRegistration.DEEP_CHALCEDONY_TEXTILES);
            this.put(BlockRegistration.DEEP_CHALCEDONY_TEXTILES, BlockRegistration.DEEP_CHALCEDONY_BORDER);
            this.put(BlockRegistration.MARBLE_BORDER, BlockRegistration.MARBLE_ACANTHUS);
            this.put(BlockRegistration.MARBLE_ACANTHUS, BlockRegistration.MARBLE_HELIX);
            this.put(BlockRegistration.MARBLE_HELIX, BlockRegistration.MARBLE_MEANDER);
            this.put(BlockRegistration.MARBLE_MEANDER, BlockRegistration.MARBLE_TEXTILES);
            this.put(BlockRegistration.MARBLE_TEXTILES, BlockRegistration.MARBLE_BORDER);
            this.put(BlockRegistration.STARRY_WALLPAPER, BlockRegistration.STARRY_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.STARRY_WALLPAPER_BOTTOM, BlockRegistration.STARRY_WALLPAPER_TOP);
            this.put(BlockRegistration.STARRY_WALLPAPER_TOP, BlockRegistration.STARRY_WALLPAPER);
            this.put(BlockRegistration.DARK_STARRY_WALLPAPER, BlockRegistration.DARK_STARRY_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.DARK_STARRY_WALLPAPER_BOTTOM, BlockRegistration.DARK_STARRY_WALLPAPER_TOP);
            this.put(BlockRegistration.DARK_STARRY_WALLPAPER_TOP, BlockRegistration.DARK_STARRY_WALLPAPER);
            this.put(BlockRegistration.CHECKERED_GREEN_WALLPAPER, BlockRegistration.CHECKERED_GREEN_STRAWBERRY_WALLPAPER);
            this.put(BlockRegistration.CHECKERED_GREEN_STRAWBERRY_WALLPAPER, BlockRegistration.CHECKERED_GREEN_WALLPAPER);
            this.put(BlockRegistration.CHECKERED_PINK_WALLPAPER, BlockRegistration.CHECKERED_PINK_STRAWBERRY_WALLPAPER);
            this.put(BlockRegistration.CHECKERED_PINK_STRAWBERRY_WALLPAPER, BlockRegistration.CHECKERED_PINK_WALLPAPER);
            this.put(BlockRegistration.CHIC_WALLPAPER, BlockRegistration.CHIC_WALLPAPER_LOWER_TRIM);
            this.put(BlockRegistration.CHIC_WALLPAPER_LOWER_TRIM, BlockRegistration.CHIC_WALLPAPER_UPPER_TRIM);
            this.put(BlockRegistration.CHIC_WALLPAPER_UPPER_TRIM, BlockRegistration.CHIC_WALLPAPER);
            this.put(BlockRegistration.GHOST_WALLPAPER, BlockRegistration.GHOST_WALLPAPER_TRIM);
            this.put(BlockRegistration.GHOST_WALLPAPER_TRIM, BlockRegistration.GHOST_WALLPAPER_WAINSCOTING);
            this.put(BlockRegistration.GHOST_WALLPAPER_WAINSCOTING, BlockRegistration.GHOST_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.GHOST_WALLPAPER_BOTTOM, BlockRegistration.GHOST_WALLPAPER_TOP);
            this.put(BlockRegistration.GHOST_WALLPAPER_TOP, BlockRegistration.GHOST_WALLPAPER);
            this.put(BlockRegistration.HALLOWEEN_WALLPAPER, BlockRegistration.HALLOWEEN_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.HALLOWEEN_WALLPAPER_BOTTOM, BlockRegistration.HALLOWEEN_WALLPAPER_TOP);
            this.put(BlockRegistration.HALLOWEEN_WALLPAPER_TOP, BlockRegistration.HALLOWEEN_WAINSCOTING);
            this.put(BlockRegistration.HALLOWEEN_WAINSCOTING, BlockRegistration.HALLOWEEN_WALLPAPER);
            this.put(BlockRegistration.PINK_STRIPE_WALLPAPER, BlockRegistration.PINK_STRIPE_WALLPAPER_LOWER_TRIM);
            this.put(BlockRegistration.PINK_STRIPE_WALLPAPER_LOWER_TRIM, BlockRegistration.PINK_STRIPE_WALLPAPER_UPPER_TRIM);
            this.put(BlockRegistration.PINK_STRIPE_WALLPAPER_UPPER_TRIM, BlockRegistration.PINK_STRIPE_WALLPAPER);
            this.put(BlockRegistration.MARIGOLD_WALLPAPER, BlockRegistration.MARIGOLD_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.MARIGOLD_WALLPAPER_BOTTOM, BlockRegistration.MARIGOLD_WALLPAPER_TOP);
            this.put(BlockRegistration.MARIGOLD_WALLPAPER_TOP, BlockRegistration.MARIGOLD_WALLPAPER);
            this.put(BlockRegistration.RIALTO_GOLD_WALLPAPER, BlockRegistration.RIALTO_GOLD_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.RIALTO_GOLD_WALLPAPER_BOTTOM, BlockRegistration.RIALTO_GOLD_WALLPAPER_TOP);
            this.put(BlockRegistration.RIALTO_GOLD_WALLPAPER_TOP, BlockRegistration.RIALTO_GOLD_WALLPAPER);
            this.put(BlockRegistration.BLUE_ROSE_STRIPED_WALLPAPER, BlockRegistration.BLUE_ROSE_STRIPED_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.BLUE_ROSE_STRIPED_WALLPAPER_BOTTOM, BlockRegistration.BLUE_ROSE_STRIPED_WALLPAPER_TOP);
            this.put(BlockRegistration.BLUE_ROSE_STRIPED_WALLPAPER_TOP, BlockRegistration.BLUE_ROSE_STRIPED_WALLPAPER);
            this.put(BlockRegistration.CONFECTIONARY_WALLPAPER, BlockRegistration.CONFECTIONARY_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.CONFECTIONARY_WALLPAPER_BOTTOM, BlockRegistration.CONFECTIONARY_WALLPAPER_TOP);
            this.put(BlockRegistration.CONFECTIONARY_WALLPAPER_TOP, BlockRegistration.BLUE_WAINSCOTING);
            this.put(BlockRegistration.BLUE_WAINSCOTING, BlockRegistration.CONFECTIONARY_WALLPAPER);
            this.put(BlockRegistration.MINT_WALLPAPER, BlockRegistration.MINT_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.MINT_WALLPAPER_BOTTOM, BlockRegistration.MINT_WALLPAPER_TOP);
            this.put(BlockRegistration.MINT_WALLPAPER_TOP, BlockRegistration.BROWN_WAINSCOTING);
            this.put(BlockRegistration.BROWN_WAINSCOTING, BlockRegistration.MINT_WALLPAPER);
            this.put(BlockRegistration.STRIPED_FLORAL_WALLPAPER, BlockRegistration.STRIPED_FLORAL_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.STRIPED_FLORAL_WALLPAPER_BOTTOM, BlockRegistration.STRIPED_FLORAL_WALLPAPER_TOP);
            this.put(BlockRegistration.STRIPED_FLORAL_WALLPAPER_TOP, BlockRegistration.STRIPED_FLORAL_WALLPAPER);
            this.put(BlockRegistration.FLORAL_BERRY_WALLPAPER, BlockRegistration.FLORAL_BERRY_WALLPAPER_BOTTOM);
            this.put(BlockRegistration.FLORAL_BERRY_WALLPAPER_BOTTOM, BlockRegistration.FLORAL_BERRY_WALLPAPER_TOP);
            this.put(BlockRegistration.FLORAL_BERRY_WALLPAPER_TOP, BlockRegistration.FLORAL_BERRY_WALLPAPER);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_APPLE, BlockRegistration.DIAMOND_WALLPAPER_APPLE_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_APPLE_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_APPLE_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_APPLE_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_APPLE_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_APPLE_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_APPLE_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_APPLE_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_APPLE_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_APPLE_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_APPLE_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_APPLE_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_APPLE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY, BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_BLACKBERRY);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY, BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_BLUEBERRY);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BONES, BlockRegistration.DIAMOND_WALLPAPER_BONES_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BONES_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BONES_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BONES_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BONES_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BONES_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BONES_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BONES_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BONES);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BOUQUET, BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BOUQUET_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_BOUQUET);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM, BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_BROWN_MUSHROOM);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES, BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_GREEN_GRAPES);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_LEMON, BlockRegistration.DIAMOND_WALLPAPER_LEMON_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_LEMON_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_LEMON_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_LEMON_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_LEMON_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_LEMON_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_LEMON_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_LEMON_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_LEMON_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_LEMON_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_LEMON_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_LEMON_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_LEMON);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ORANGE, BlockRegistration.DIAMOND_WALLPAPER_ORANGE_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ORANGE_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_ORANGE_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ORANGE_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_ORANGE_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ORANGE_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_ORANGE_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ORANGE_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_ORANGE_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ORANGE_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_ORANGE_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ORANGE_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_ORANGE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PEAR, BlockRegistration.DIAMOND_WALLPAPER_PEAR_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PEAR_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_PEAR_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PEAR_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_PEAR_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PEAR_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_PEAR_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PEAR_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_PEAR_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PEAR_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_PEAR_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PEAR_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_PEAR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PLUM, BlockRegistration.DIAMOND_WALLPAPER_PLUM_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PLUM_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_PLUM_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PLUM_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_PLUM_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PLUM_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_PLUM_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PLUM_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_PLUM_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PLUM_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_PLUM_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PLUM_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_PLUM);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES, BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_PURPLE_GRAPES);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM, BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_RED_MUSHROOM);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY, BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_BOTTOM_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_BOTTOM_COLOR, BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_TOP_COLOR);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY_TOP_COLOR, BlockRegistration.DIAMOND_WALLPAPER_STRAWBERRY);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ANCHOR, BlockRegistration.DIAMOND_WALLPAPER_ANCHOR_BOTTOM_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ANCHOR_BOTTOM_BROWN, BlockRegistration.DIAMOND_WALLPAPER_ANCHOR_TOP_BROWN);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ANCHOR_TOP_BROWN, BlockRegistration.DIAMOND_WALLPAPER_ANCHOR_BOTTOM_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ANCHOR_BOTTOM_WHITE, BlockRegistration.DIAMOND_WALLPAPER_ANCHOR_TOP_WHITE);
            this.put(BlockRegistration.DIAMOND_WALLPAPER_ANCHOR_TOP_WHITE, BlockRegistration.DIAMOND_WALLPAPER_ANCHOR);
            this.put(BlockRegistration.GINGERBREAD_BRICKS, BlockRegistration.GINGERBREAD_BRICKS_TOP);
            this.put(BlockRegistration.GINGERBREAD_BRICKS_TOP, BlockRegistration.GINGERBREAD_BRICKS_SIDE);
            this.put(BlockRegistration.GINGERBREAD_BRICKS_SIDE, BlockRegistration.GINGERBREAD_BRICKS_TOP_CORNER);
            this.put(BlockRegistration.GINGERBREAD_BRICKS_TOP_CORNER, BlockRegistration.GINGERBREAD_BRICKS);
            this.put(BlockRegistration.MARBLE_TILE, BlockRegistration.MARBLE_TILE_CHISELED);
            this.put(BlockRegistration.MARBLE_TILE_CHISELED, BlockRegistration.MARBLE_TILE_BORDER);
            this.put(BlockRegistration.MARBLE_TILE_BORDER, BlockRegistration.MARBLE_TILE_BORDER_CIRCLE);
            this.put(BlockRegistration.MARBLE_TILE_BORDER_CIRCLE, BlockRegistration.MARBLE_TILE_BORDER_DETAIL);
            this.put(BlockRegistration.MARBLE_TILE_BORDER_DETAIL, BlockRegistration.MARBLE_TILE_CORNER);
            this.put(BlockRegistration.MARBLE_TILE_CORNER, BlockRegistration.MARBLE_TILE_CORNER_CIRCLE);
            this.put(BlockRegistration.MARBLE_TILE_CORNER_CIRCLE, BlockRegistration.MARBLE_TILE);
            this.put(BlockRegistration.VERDANT_TILE, BlockRegistration.VERDANT_TILE_EDGE);
            this.put(BlockRegistration.VERDANT_TILE_EDGE, BlockRegistration.VERDANT_TILE_CORNER);
            this.put(BlockRegistration.VERDANT_TILE_CORNER, BlockRegistration.VERDANT_TILE);
            this.put(BlockRegistration.X_TILE_TERRACOTTA, BlockRegistration.X_TILE_INVERSE_TERRACOTTA);
            this.put(BlockRegistration.X_TILE_INVERSE_TERRACOTTA, BlockRegistration.X_TILE_TERRACOTTA);
            this.put(BlockRegistration.X_TILE_BLUE, BlockRegistration.X_TILE_INVERSE_BLUE);
            this.put(BlockRegistration.X_TILE_INVERSE_BLUE, BlockRegistration.X_TILE_BLUE);
            this.put(BlockRegistration.X_TILE_GRAY, BlockRegistration.X_TILE_INVERSE_GRAY);
            this.put(BlockRegistration.X_TILE_INVERSE_GRAY, BlockRegistration.X_TILE_GRAY);
            this.put(BlockRegistration.VARYING_BRICKS, BlockRegistration.VARYING_BRICKS_BORDER);
            this.put(BlockRegistration.VARYING_BRICKS_BORDER, BlockRegistration.VARYING_BRICKS);
            this.put(BlockRegistration.ALABASTER_WINDOW_DIVIDED, BlockRegistration.GREENHOUSE_WINDOW);
            this.put(BlockRegistration.GREENHOUSE_WINDOW, BlockRegistration.GREENHOUSE_WINDOW_ARCH_LEFT);
            this.put(BlockRegistration.GREENHOUSE_WINDOW_ARCH_LEFT, BlockRegistration.GREENHOUSE_WINDOW_ARCH_RIGHT);
            this.put(BlockRegistration.GREENHOUSE_WINDOW_ARCH_RIGHT, BlockRegistration.GREENHOUSE_WINDOW_POINT);
            this.put(BlockRegistration.GREENHOUSE_WINDOW_POINT, BlockRegistration.GREENHOUSE_WINDOW_RADIAL_LEFT);
            this.put(BlockRegistration.GREENHOUSE_WINDOW_RADIAL_LEFT, BlockRegistration.GREENHOUSE_WINDOW_RADIAL_RIGHT);
            this.put(BlockRegistration.GREENHOUSE_WINDOW_RADIAL_RIGHT, BlockRegistration.GREENHOUSE_WINDOW_ROUNDED);
            this.put(BlockRegistration.GREENHOUSE_WINDOW_ROUNDED, BlockRegistration.GREENHOUSE_WINDOW_CIRCLE);
            this.put(BlockRegistration.GREENHOUSE_WINDOW_CIRCLE, BlockRegistration.ALABASTER_WINDOW_DIVIDED);
            this.put(BlockRegistration.CHALCEDONY_BRACKET_SCROLL_SHELF, BlockRegistration.CHALCEDONY_BRACKET_VICTORIAN);
            this.put(BlockRegistration.CHALCEDONY_BRACKET_VICTORIAN, BlockRegistration.CHALCEDONY_BRACKET_SCROLL);
            this.put(BlockRegistration.CHALCEDONY_BRACKET_SCROLL, BlockRegistration.CHALCEDONY_BRACKET_BOW_SCROLL);
            this.put(BlockRegistration.CHALCEDONY_BRACKET_BOW_SCROLL, BlockRegistration.CHALCEDONY_BRACKET_BOW);
            this.put(BlockRegistration.CHALCEDONY_BRACKET_BOW, BlockRegistration.CHALCEDONY_BRACKET_STAR);
            this.put(BlockRegistration.CHALCEDONY_BRACKET_STAR, BlockRegistration.CHALCEDONY_BRACKET_STAR_SCROLL);
            this.put(BlockRegistration.CHALCEDONY_BRACKET_STAR_SCROLL, BlockRegistration.CHALCEDONY_BRACKET_SCROLL_SHELF);
            this.put(BlockRegistration.DEEP_CHALCEDONY_BRACKET_SCROLL_SHELF, BlockRegistration.DEEP_CHALCEDONY_BRACKET_VICTORIAN);
            this.put(BlockRegistration.DEEP_CHALCEDONY_BRACKET_VICTORIAN, BlockRegistration.DEEP_CHALCEDONY_BRACKET_SCROLL);
            this.put(BlockRegistration.DEEP_CHALCEDONY_BRACKET_SCROLL, BlockRegistration.DEEP_CHALCEDONY_BRACKET_BOW_SCROLL);
            this.put(BlockRegistration.DEEP_CHALCEDONY_BRACKET_BOW_SCROLL, BlockRegistration.DEEP_CHALCEDONY_BRACKET_BOW);
            this.put(BlockRegistration.DEEP_CHALCEDONY_BRACKET_BOW, BlockRegistration.DEEP_CHALCEDONY_BRACKET_STAR);
            this.put(BlockRegistration.DEEP_CHALCEDONY_BRACKET_STAR, BlockRegistration.DEEP_CHALCEDONY_BRACKET_STAR_SCROLL);
            this.put(BlockRegistration.DEEP_CHALCEDONY_BRACKET_STAR_SCROLL, BlockRegistration.DEEP_CHALCEDONY_BRACKET_SCROLL_SHELF);
            this.put(BlockRegistration.MARBLE_BRACKET_SCROLL_SHELF, BlockRegistration.MARBLE_BRACKET_VICTORIAN);
            this.put(BlockRegistration.MARBLE_BRACKET_VICTORIAN, BlockRegistration.MARBLE_BRACKET_SCROLL);
            this.put(BlockRegistration.MARBLE_BRACKET_SCROLL, BlockRegistration.MARBLE_BRACKET_BOW_SCROLL);
            this.put(BlockRegistration.MARBLE_BRACKET_BOW_SCROLL, BlockRegistration.MARBLE_BRACKET_BOW);
            this.put(BlockRegistration.MARBLE_BRACKET_BOW, BlockRegistration.MARBLE_BRACKET_STAR);
            this.put(BlockRegistration.MARBLE_BRACKET_STAR, BlockRegistration.MARBLE_BRACKET_STAR_SCROLL);
            this.put(BlockRegistration.MARBLE_BRACKET_STAR_SCROLL, BlockRegistration.MARBLE_BRACKET_SCROLL_SHELF);
            this.put(BlockRegistration.WOODEN_BRACKET_SCROLL_SHELF, BlockRegistration.WOODEN_BRACKET_VICTORIAN);
            this.put(BlockRegistration.WOODEN_BRACKET_VICTORIAN, BlockRegistration.WOODEN_BRACKET_SCROLL);
            this.put(BlockRegistration.WOODEN_BRACKET_SCROLL, BlockRegistration.WOODEN_BRACKET_BOW_SCROLL);
            this.put(BlockRegistration.WOODEN_BRACKET_BOW_SCROLL, BlockRegistration.WOODEN_BRACKET_BOW);
            this.put(BlockRegistration.WOODEN_BRACKET_BOW, BlockRegistration.WOODEN_BRACKET_STAR);
            this.put(BlockRegistration.WOODEN_BRACKET_STAR, BlockRegistration.WOODEN_BRACKET_STAR_SCROLL);
            this.put(BlockRegistration.WOODEN_BRACKET_STAR_SCROLL, BlockRegistration.WOODEN_BRACKET_SCROLL_SHELF);
        }
    };

    public HandDrillItem(Item.Properties pProperties) {
        super(pProperties);
    }

    private BlockState getNextBlock(BlockState block) {
        if (BLOCK_CYCLE_MAP.containsKey(block.getBlock().builtInRegistryHolder())) {
            return ((Block)BLOCK_CYCLE_MAP.get(block.getBlock().builtInRegistryHolder()).value()).defaultBlockState();
        }
        return null;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        BlockState state = level.getBlockState(pos);
        BlockState nextState = this.getNextBlock(state);
        if (pContext.getPlayer().isCrouching()) {
            if (!level.isClientSide) {
                if (state.getBlock() instanceof MultiblockPlacer || state.getBlock() instanceof BedBlock) {
                    return InteractionResult.CONSUME;
                }
                if (state.getBlock() instanceof BracketBlock) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)BracketBlock.OFFSET, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)BracketBlock.OFFSET) == false)), 2);
                    level.playSound(null, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS);
                    return InteractionResult.SUCCESS;
                }
                if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                    HandDrillItem.facingRotation(state, level, pos);
                } else if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
                    HandDrillItem.axisRotation(state, level, pos);
                } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    HandDrillItem.horizontalFacingRotation(state, level, pos);
                } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                    HandDrillItem.horizontalAxisRotation(state, level, pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (nextState != null) {
            if (!level.isClientSide) {
                if (state.getBlock() instanceof BracketBlock) {
                    level.setBlock(pos, (BlockState)((BlockState)((BlockState)nextState.setValue((Property)BracketBlock.IS_UP, (Comparable)((Boolean)state.getValue((Property)BracketBlock.IS_UP)))).setValue((Property)BracketBlock.OFFSET, (Comparable)((Boolean)state.getValue((Property)BracketBlock.OFFSET)))).setValue((Property)BracketBlock.FACING, (Comparable)((Direction)state.getValue((Property)BracketBlock.FACING))), 3);
                } else {
                    level.setBlock(pos, this.swapAxisAndFacing(state, nextState, pContext.getHorizontalDirection()), 3);
                }
                level.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void facingRotation(BlockState state, Level level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        facing = facing == Direction.WEST ? Direction.UP : (facing == Direction.UP ? facing.getOpposite() : (facing == Direction.DOWN ? Direction.NORTH : facing.getClockWise()));
        level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)facing), 2);
        level.playSound(null, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS);
    }

    private static void axisRotation(BlockState state, Level level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
        axis = axis == Direction.Axis.X ? Direction.Axis.Y : (axis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.X);
        level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis), 2);
        level.playSound(null, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS);
    }

    private static void horizontalFacingRotation(BlockState state, Level level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        facing = facing.getClockWise();
        level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing), 2);
        level.playSound(null, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS);
    }

    private static void horizontalAxisRotation(BlockState state, Level level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
        axis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)axis), 2);
        level.playSound(null, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS);
    }

    private BlockState swapAxisAndFacing(BlockState state, BlockState nextState, Direction playerFacing) {
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
            if (nextState.hasProperty((Property)BlockStateProperties.AXIS)) {
                return (BlockState)nextState.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
            }
            if (nextState.hasProperty((Property)BlockStateProperties.FACING)) {
                if (!axis.equals((Object)Direction.Axis.Y)) {
                    return (BlockState)nextState.setValue((Property)BlockStateProperties.FACING, (Comparable)playerFacing);
                }
                return (BlockState)nextState.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP);
            }
        } else if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            if (nextState.hasProperty((Property)BlockStateProperties.FACING)) {
                return (BlockState)nextState.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
            }
            if (nextState.hasProperty((Property)BlockStateProperties.AXIS)) {
                if (facing.equals((Object)Direction.UP) || facing.equals((Object)Direction.DOWN)) {
                    return (BlockState)nextState.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
                }
                if (facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) {
                    return (BlockState)nextState.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
                }
                return (BlockState)nextState.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
            }
            return nextState;
        }
        return nextState;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"cluttered.hand_drill.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

