/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.setup.TagRegistration;

public class ClutteredItemTags
extends ItemTagsProvider {
    public ClutteredItemTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, BlockTagsProvider blockTags, ExistingFileHelper existingFileHelper) {
        super(packOutput, lookupProvider, blockTags.contentsGetter(), "cluttered", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tagNewWoodset("willow");
        this.tagNewWoodset("flowering_willow");
        this.tagNewWoodset("poplar");
        this.tagNewWoodset("flowering_poplar");
        this.tagNewWoodset("crabapple");
        this.tagNewWoodset("flowering_crabapple");
        this.tagNewWoodset("sycamore");
        this.tagNewWoodset("fluorescent_maple");
        this.tagNewWoodset("blue_mushroom");
        this.tagNewWoodset("red_mushroom");
        this.tag(ItemTags.DOORS).add((Object)((Block)BlockRegistration.WILLOW_LOG_DOOR.get()).asItem()).add((Object)((Block)BlockRegistration.WILLOW_GARDEN_DOOR.get()).asItem()).add((Object)((Block)BlockRegistration.DYNASTY_DOOR.get()).asItem()).add((Object)((Block)BlockRegistration.ART_NOUVEAU_DOOR_DARK.get()).asItem()).add((Object)((Block)BlockRegistration.ART_NOUVEAU_DOOR.get()).asItem());
        this.tag(ItemTags.WOODEN_DOORS).add((Object)((Block)BlockRegistration.WILLOW_LOG_DOOR.get()).asItem()).add((Object)((Block)BlockRegistration.WILLOW_GARDEN_DOOR.get()).asItem()).add((Object)((Block)BlockRegistration.DYNASTY_DOOR.get()).asItem()).add((Object)((Block)BlockRegistration.ART_NOUVEAU_DOOR_DARK.get()).asItem()).add((Object)((Block)BlockRegistration.ART_NOUVEAU_DOOR.get()).asItem());
        this.tag(ItemTags.STONE_CRAFTING_MATERIALS).add((Object)((Block)BlockRegistration.CHALCEDONY.get()).asItem()).add((Object)((Block)BlockRegistration.DEEP_CHALCEDONY.get()).asItem()).add((Object)((Block)BlockRegistration.MARBLE.get()).asItem());
        this.tag(ItemTags.STONE_TOOL_MATERIALS).add((Object)((Block)BlockRegistration.CHALCEDONY.get()).asItem()).add((Object)((Block)BlockRegistration.DEEP_CHALCEDONY.get()).asItem()).add((Object)((Block)BlockRegistration.MARBLE.get()).asItem());
        this.tag(ItemTags.SAPLINGS).add((Object)((Block)BlockRegistration.WILLOW_SAPLING.get()).asItem()).add((Object)((Block)BlockRegistration.POPLAR_SAPLING.get()).asItem());
        this.tag(ItemTags.LEAVES).add((Object)((Block)BlockRegistration.WILLOW_LEAVES.get()).asItem()).add((Object)((Block)BlockRegistration.POPLAR_LEAVES.get()).asItem());
        this.tag(TagRegistration.Items.POLAROID_PICTURE).add((Object)((Block)BlockRegistration.POLAROIDS_A.get()).asItem()).add((Object)((Block)BlockRegistration.POLAROIDS_B.get()).asItem()).add((Object)((Block)BlockRegistration.POLAROIDS_C.get()).asItem());
        this.tag(ItemTags.LEAVES).add((Object)((Block)BlockRegistration.MAPLE_LEAVES_FLOWERING.get()).asItem());
        this.tag(TagRegistration.Items.WILLOW_LOG).add((Object)((Block)BlockRegistration.WILLOW_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.WILLOW_WOOD.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_WILLOW_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_WILLOW_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.FLOWERING_WILLOW_LOG).add((Object)((Block)BlockRegistration.FLOWERING_WILLOW_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.FLOWERING_WILLOW_WOOD.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_FLOWERING_WILLOW_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_FLOWERING_WILLOW_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.POPLAR_LOG).add((Object)((Block)BlockRegistration.POPLAR_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.POPLAR_WOOD.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_POPLAR_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_POPLAR_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.FLOWERING_POPLAR_LOG).add((Object)((Block)BlockRegistration.FLOWERING_POPLAR_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.FLOWERING_POPLAR_WOOD.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_FLOWERING_POPLAR_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_FLOWERING_POPLAR_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.CRABAPPLE_LOG).add((Object)((Block)BlockRegistration.CRABAPPLE_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.CRABAPPLE_WOOD.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_CRABAPPLE_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_CRABAPPLE_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.FLOWERING_CRABAPPLE_LOG).add((Object)((Block)BlockRegistration.FLOWERING_CRABAPPLE_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.FLOWERING_CRABAPPLE_WOOD.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_FLOWERING_CRABAPPLE_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_FLOWERING_CRABAPPLE_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.SYCAMORE_LOG).add((Object)((Block)BlockRegistration.SYCAMORE_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.SYCAMORE_WOOD.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_SYCAMORE_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_SYCAMORE_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.MAPLE_LOG).add((Object)((Block)BlockRegistration.MAPLE_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.MAPLE_WOOD.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_MAPLE_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.STRIPPED_MAPLE_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.BLUE_MUSHROOM_LOG).add((Object)((Block)BlockRegistration.BLUE_MUSHROOM_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.BLUE_MUSHROOM_WOOD.get()).asItem());
        this.tag(TagRegistration.Items.RED_MUSHROOM_LOG).add((Object)((Block)BlockRegistration.RED_MUSHROOM_LOG.get()).asItem()).add((Object)((Block)BlockRegistration.RED_MUSHROOM_WOOD.get()).asItem());
        this.tag(Tags.Items.STORAGE_BLOCKS_GOLD).add((Object)((Block)BlockRegistration.CHISELED_GOLD_BLOCK.get()).asItem());
    }

    public void tagNewWoodset(String woodType) {
        Item log = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_log")))).asItem();
        Item wood = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_wood")))).asItem();
        Item strippedLog = null;
        Item strippedWood = null;
        if (BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)("stripped_" + woodType + "_log")))) {
            strippedLog = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)("stripped_" + woodType + "_log")))).asItem();
            strippedWood = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)("stripped_" + woodType + "_wood")))).asItem();
        }
        Item planks = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_planks")))).asItem();
        Item stairs = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_stairs")))).asItem();
        Item slab = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_slab")))).asItem();
        Item fence = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_fence")))).asItem();
        Item fenceGate = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_fence_gate")))).asItem();
        Item button = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_button")))).asItem();
        Item sign = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_sign")));
        Item hangingSign = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_hanging_sign")));
        Item pressurePlate = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_pressure_plate")))).asItem();
        Item door = null;
        if (BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_door")))) {
            door = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_door")))).asItem();
        }
        Item trapdoor = null;
        if (BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_trapdoor")))) {
            trapdoor = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_trapdoor")))).asItem();
        }
        Item window = null;
        if (BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_window")))) {
            window = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_window")))).asItem();
        }
        Item bookshelf = null;
        if (BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_bookshelf")))) {
            bookshelf = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_bookshelf")))).asItem();
        }
        Item leaves = null;
        if (BuiltInRegistries.BLOCK.containsKey(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_leaves")))) {
            leaves = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_leaves")))).asItem();
        }
        this.tag(ItemTags.LOGS).add((Object)log).add((Object)wood);
        this.tag(ItemTags.LOGS_THAT_BURN).add((Object)log).add((Object)wood);
        this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_logs")))).add((Object)log).add((Object)wood);
        if (strippedLog != null) {
            this.tag(ItemTags.LOGS).add((Object)strippedLog).add((Object)strippedWood);
            this.tag(ItemTags.LOGS_THAT_BURN).add((Object)strippedLog).add((Object)strippedWood);
            this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cluttered", (String)(woodType + "_logs")))).add((Object)strippedLog).add((Object)strippedWood);
        }
        this.tag(ItemTags.PLANKS).add((Object)planks);
        this.tag(ItemTags.STAIRS).add((Object)stairs);
        this.tag(ItemTags.WOODEN_STAIRS).add((Object)stairs);
        this.tag(ItemTags.SLABS).add((Object)slab);
        this.tag(ItemTags.SIGNS).add((Object)sign);
        this.tag(ItemTags.HANGING_SIGNS).add((Object)hangingSign);
        this.tag(ItemTags.WOODEN_SLABS).add((Object)slab);
        this.tag(ItemTags.FENCES).add((Object)fence);
        this.tag(ItemTags.WOODEN_FENCES).add((Object)fence);
        this.tag(ItemTags.FENCE_GATES).add((Object)fenceGate);
        this.tag(ItemTags.BUTTONS).add((Object)button);
        this.tag(ItemTags.WOODEN_BUTTONS).add((Object)button);
        this.tag(ItemTags.WOODEN_PRESSURE_PLATES).add((Object)pressurePlate);
        if (door != null) {
            this.tag(ItemTags.DOORS).add((Object)door);
            this.tag(ItemTags.WOODEN_DOORS).add((Object)door);
        }
        if (trapdoor != null) {
            this.tag(ItemTags.TRAPDOORS).add((Object)trapdoor);
            this.tag(ItemTags.WOODEN_TRAPDOORS).add((Object)trapdoor);
        }
        if (leaves != null) {
            this.tag(ItemTags.LEAVES).add((Object)leaves);
        }
    }
}

