/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.storage.MultiblockStorage;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class PastelWardrobeBlock
extends MultiblockStorage {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_TOP = Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)6);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {2}}, new int[][]{{3}, {4}}, new int[][]{{5}, {6}}};

    public PastelWardrobeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape;
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        switch (facing) {
            case SOUTH: {
                VoxelShape voxelShape;
                if (part % 2 == 1) {
                    voxelShape = SHAPE_SOUTH;
                    break;
                }
                voxelShape = SHAPE_NORTH;
                break;
            }
            case EAST: {
                VoxelShape voxelShape;
                if (part % 2 == 1) {
                    voxelShape = SHAPE_EAST;
                    break;
                }
                voxelShape = SHAPE_WEST;
                break;
            }
            case WEST: {
                VoxelShape voxelShape;
                if (part % 2 == 1) {
                    voxelShape = SHAPE_WEST;
                    break;
                }
                voxelShape = SHAPE_EAST;
                break;
            }
            default: {
                VoxelShape voxelShape = shape = part % 2 == 1 ? SHAPE_NORTH : SHAPE_SOUTH;
            }
        }
        if (part == 1 || part == 2) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_BOTTOM);
        } else if (part == 5 || part == 6) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_TOP);
        }
        return shape;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)this.getMultiblockPart()) != 1) {
            return null;
        }
        return ((BlockEntityType)TileEntityRegistration.SIX_ROWS_BE.get()).create(blockPos, blockState);
    }
}

