/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.entity.CustomStorageBlockEntity;
import net.redchujelly.cluttered.block.multiblock.storage.MultiblockStorage;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends MultiblockStorage {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}}, new int[][]{{2}}};

    public FridgeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public void setOpenAndClosed(Level level, BlockPos pos, BlockState state, boolean open) {
        int part = (Integer)state.getValue((Property)this.getMultiblockPart());
        BlockPos otherHalfPos = part == 1 ? pos.above() : pos.below();
        BlockState otherHalfBlock = level.getBlockState(otherHalfPos);
        if (state.hasProperty((Property)OPEN)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 2);
            if (level.getBlockState(otherHalfPos).getBlock().equals(state.getBlock()) && (Integer)otherHalfBlock.getValue((Property)this.getMultiblockPart()) != part) {
                level.setBlock(otherHalfPos, (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open))).setValue((Property)this.getMultiblockPart(), (Comparable)Integer.valueOf(part == 1 ? 2 : 1)), 2);
            }
        }
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.isCrouching()) {
            BlockPos pos1 = this.findBlockState1(pPos, (LevelAccessor)pLevel);
            BlockEntity blockEntity = pLevel.getBlockEntity(pos1);
            if (blockEntity instanceof CustomStorageBlockEntity) {
                pPlayer.openMenu((MenuProvider)((CustomStorageBlockEntity)blockEntity));
                return InteractionResult.CONSUME;
            }
        } else {
            this.setOpenAndClosed(pLevel, pPos, pState, (Boolean)pState.getValue((Property)OPEN) == false);
            pLevel.playSound(null, pPos, (Boolean)pState.getValue((Property)OPEN) != false ? SoundEvents.IRON_DOOR_CLOSE : SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)this.getMultiblockPart()) != 1) {
            return null;
        }
        return ((BlockEntityType)TileEntityRegistration.RETRO_FRIDGE_BE.get()).create(blockPos, blockState);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OPEN});
    }
}

