/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.entity.CustomStorageBlockEntity;
import net.redchujelly.cluttered.block.multiblock.storage.MultiblockStorage;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class CottageBookcaseBlock
extends MultiblockStorage {
    private static final VoxelShape SHAPE_N_1 = Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_S_1 = Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E_1 = Block.box((double)2.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W_1 = Block.box((double)0.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N_2 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)14.0), (VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)10.0));
    private static final VoxelShape SHAPE_S_2 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)8.0, (double)6.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_E_2 = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_W_2 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)8.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0));
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}}, new int[][]{{2}}};

    @Override
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if ((Integer)pState.getValue((Property)this.getMultiblockPart()) != 1) {
            return InteractionResult.FAIL;
        }
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos1 = this.findBlockState1(pPos, (LevelAccessor)pLevel);
        BlockEntity blockEntity = pLevel.getBlockEntity(pos1);
        if (blockEntity instanceof CustomStorageBlockEntity) {
            pPlayer.openMenu((MenuProvider)((CustomStorageBlockEntity)blockEntity));
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (part == 1) {
                    yield SHAPE_S_1;
                }
                yield SHAPE_S_2;
            }
            case Direction.EAST -> {
                if (part == 1) {
                    yield SHAPE_E_1;
                }
                yield SHAPE_E_2;
            }
            case Direction.WEST -> {
                if (part == 1) {
                    yield SHAPE_W_1;
                }
                yield SHAPE_W_2;
            }
            default -> part == 1 ? SHAPE_N_1 : SHAPE_N_2;
        };
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)this.getMultiblockPart()) != 1) {
            return null;
        }
        return ((BlockEntityType)TileEntityRegistration.THREE_ROWS_BE.get()).create(blockPos, blockState);
    }

    public CottageBookcaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }
}

