/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.storage.MultiblockStorage;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class ChinaCabinetBlock
extends MultiblockStorage {
    private static final VoxelShape SHAPE_1_N = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_1_S = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_1_E = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_1_W = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_2_N = Shapes.join((VoxelShape)Block.box((double)1.0, (double)14.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_2_S = Shapes.join((VoxelShape)Block.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_2_E = Shapes.join((VoxelShape)Block.box((double)1.0, (double)14.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_2_W = Shapes.join((VoxelShape)Block.box((double)0.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}}, new int[][]{{2}}};

    public ChinaCabinetBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (part == 1) {
                    yield SHAPE_1_S;
                }
                yield SHAPE_2_S;
            }
            case Direction.EAST -> {
                if (part == 1) {
                    yield SHAPE_1_E;
                }
                yield SHAPE_2_E;
            }
            case Direction.WEST -> {
                if (part == 1) {
                    yield SHAPE_1_W;
                }
                yield SHAPE_2_W;
            }
            default -> part == 1 ? SHAPE_1_N : SHAPE_2_N;
        };
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)this.getMultiblockPart()) != 1) {
            return null;
        }
        return ((BlockEntityType)TileEntityRegistration.THREE_ROWS_BE.get()).create(blockPos, blockState);
    }
}

