/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.PicketFenceGateBlock;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;
import org.jetbrains.annotations.Nullable;

public class WeddingArchBlock
extends MultiblockPlacer {
    private static final VoxelShape SUPPORT_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    private static final VoxelShape SHAPE_1367 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_N_1367 = Block.box((double)6.0, (double)0.0, (double)8.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_S_1367 = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)8.0);
    private static final VoxelShape SHAPE_E_1367 = Block.box((double)0.0, (double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_W_1367 = Block.box((double)8.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_N_35 = Block.box((double)2.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_S_35 = Block.box((double)0.0, (double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_E_35 = Block.box((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W_35 = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_NS_4 = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_EW_4 = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)7);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {0}, {7}}, new int[][]{{2}, {0}, {6}}, new int[][]{{3}, {4}, {5}}};

    public WeddingArchBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SUPPORT_SHAPE;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape1;
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        if (part == 1 || part == 2 || part == 6 || part == 7) {
            shape1 = SHAPE_1367;
        } else if (part == 4) {
            shape1 = facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? SHAPE_NS_4 : SHAPE_EW_4;
        } else {
            switch (facing) {
                case SOUTH: {
                    VoxelShape voxelShape;
                    if (part == 3) {
                        voxelShape = SHAPE_S_35;
                        break;
                    }
                    voxelShape = SHAPE_N_35;
                    break;
                }
                case EAST: {
                    VoxelShape voxelShape;
                    if (part == 3) {
                        voxelShape = SHAPE_E_35;
                        break;
                    }
                    voxelShape = SHAPE_W_35;
                    break;
                }
                case WEST: {
                    VoxelShape voxelShape;
                    if (part == 3) {
                        voxelShape = SHAPE_W_35;
                        break;
                    }
                    voxelShape = SHAPE_E_35;
                    break;
                }
                default: {
                    VoxelShape voxelShape = shape1 = part == 3 ? SHAPE_N_35 : SHAPE_S_35;
                }
            }
        }
        if (((Boolean)pState.getValue((Property)SOUTH)).booleanValue()) {
            shape1 = Shapes.or((VoxelShape)shape1, (VoxelShape)SHAPE_N_1367);
        }
        if (((Boolean)pState.getValue((Property)NORTH)).booleanValue()) {
            shape1 = Shapes.or((VoxelShape)shape1, (VoxelShape)SHAPE_S_1367);
        }
        if (((Boolean)pState.getValue((Property)WEST)).booleanValue()) {
            shape1 = Shapes.or((VoxelShape)shape1, (VoxelShape)SHAPE_E_1367);
        }
        if (((Boolean)pState.getValue((Property)EAST)).booleanValue()) {
            shape1 = Shapes.or((VoxelShape)shape1, (VoxelShape)SHAPE_W_1367);
        }
        return shape1;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level level = pContext.getLevel();
        BlockPos OGpos = pContext.getClickedPos();
        Direction direction = pContext.getHorizontalDirection();
        int[][][] multiblockShape = this.getMultiblockShape();
        int maxHeight = this.getMultiblockShape().length;
        int OGx = OGpos.getX();
        int OGy = OGpos.getY();
        int OGz = OGpos.getZ();
        int xOffset = 0;
        int zOffset = 0;
        if (OGpos.getY() + maxHeight >= level.getMaxBuildHeight()) {
            return null;
        }
        for (int y = 0; y < maxHeight; ++y) {
            for (int x = 0; x < multiblockShape[y].length; ++x) {
                for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                    if (multiblockShape[y][x][z] == 0 || level.getBlockState(new BlockPos(OGx + (xOffset = this.getXOffset(direction, x, z)), OGy + y, OGz + (zOffset = this.getZOffset(direction, x, z)))).canBeReplaced()) continue;
                    return null;
                }
            }
        }
        Level $$1 = pContext.getLevel();
        BlockPos $$2 = pContext.getClickedPos();
        BlockPos $$4 = $$2.north();
        BlockPos $$5 = $$2.east();
        BlockPos $$6 = $$2.south();
        BlockPos $$7 = $$2.west();
        BlockState $$8 = $$1.getBlockState($$4);
        BlockState $$9 = $$1.getBlockState($$5);
        BlockState $$10 = $$1.getBlockState($$6);
        BlockState $$11 = $$1.getBlockState($$7);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo($$8)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo($$9)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo($$10)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo($$11)));
    }

    @Override
    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            Direction direction = (Direction)pState.getValue((Property)FACING);
            int[][][] multiblockShape = this.getMultiblockShape();
            int OGx = pPos.getX();
            int OGy = pPos.getY();
            int OGz = pPos.getZ();
            if ((Integer)pState.getValue((Property)this.getMultiblockPart()) == 1 && !pOldState.is(this.asBlock())) {
                for (int y = 0; y < multiblockShape.length; ++y) {
                    for (int x = 0; x < multiblockShape[y].length; ++x) {
                        for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                            if (x + y + z == 0 || multiblockShape[y][x][z] == 0) continue;
                            int xOffset = this.getXOffset(direction, x, z);
                            int zOffset = this.getZOffset(direction, x, z);
                            Level $$1 = pLevel;
                            BlockPos $$2 = new BlockPos(OGx + xOffset, OGy + y, OGz + zOffset);
                            BlockPos $$4 = $$2.north();
                            BlockPos $$5 = $$2.east();
                            BlockPos $$6 = $$2.south();
                            BlockPos $$7 = $$2.west();
                            BlockState $$8 = $$1.getBlockState($$4);
                            BlockState $$9 = $$1.getBlockState($$5);
                            BlockState $$10 = $$1.getBlockState($$6);
                            BlockState $$11 = $$1.getBlockState($$7);
                            pLevel.setBlock($$2, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getMultiblockPart(), (Comparable)Integer.valueOf(multiblockShape[y][x][z]))).setValue((Property)FACING, (Comparable)direction)).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo($$8)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo($$9)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo($$10)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo($$11))), 2);
                        }
                    }
                }
            }
        }
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection.equals((Object)Direction.NORTH)) {
            pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(pNeighborState))), 2);
        } else if (pDirection.equals((Object)Direction.SOUTH)) {
            pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(pNeighborState))), 2);
        } else if (pDirection.equals((Object)Direction.EAST)) {
            pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(pNeighborState))), 2);
        } else if (pDirection.equals((Object)Direction.WEST)) {
            pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(pNeighborState))), 2);
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private boolean connectsTo(BlockState pState) {
        boolean neighborFence;
        if (pState.getBlock() instanceof WeddingArchBlock) {
            return false;
        }
        boolean bl = neighborFence = pState.is(BlockTags.WOODEN_FENCES) || pState.is(BlockTags.FENCES) || pState.is(BlockTags.WALLS);
        if (!neighborFence && (pState.getBlock() instanceof FenceGateBlock || pState.getBlock() instanceof PicketFenceGateBlock)) {
            neighborFence = ((Direction)pState.getValue((Property)FACING)).equals((Object)pState.getValue((Property)FACING)) || ((Direction)pState.getValue((Property)FACING)).equals((Object)((Direction)pState.getValue((Property)FACING)).getOpposite());
        }
        return neighborFence;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{NORTH}).add(new Property[]{SOUTH}).add(new Property[]{EAST}).add(new Property[]{WEST});
    }
}

