/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;

public class VioletScreenBlock
extends MultiblockPlacer {
    private static final VoxelShape SHAPE_14_N = Block.box((double)2.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_14_S = Block.box((double)0.0, (double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_14_E = Block.box((double)6.0, (double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_14_W = Block.box((double)3.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_2356_N = Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_2356_S = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_2356_E = Block.box((double)6.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_2356_W = Block.box((double)3.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)6);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {2}, {3}}, new int[][]{{4}, {5}, {6}}};

    public VioletScreenBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (part == 1 || part == 4) {
                    yield SHAPE_14_S;
                }
                yield SHAPE_2356_S;
            }
            case Direction.EAST -> {
                if (part == 1 || part == 4) {
                    yield SHAPE_14_E;
                }
                yield SHAPE_2356_E;
            }
            case Direction.WEST -> {
                if (part == 1 || part == 4) {
                    yield SHAPE_14_W;
                }
                yield SHAPE_2356_W;
            }
            default -> part == 1 || part == 4 ? SHAPE_14_N : SHAPE_2356_N;
        };
    }
}

