/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class MultiblockPlacer
extends Block {
    private static final MapCodec<MultiblockPlacer> CODEC = MultiblockPlacer.simpleCodec(MultiblockPlacer::new);
    private static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)2);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}}};

    public int[][][] getMultiblockShape() {
        return this.MULTIBLOCK_SHAPE;
    }

    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public MultiblockPlacer(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)this.getMultiblockPart(), (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING}).add(new Property[]{this.getMultiblockPart()});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level level = pContext.getLevel();
        BlockPos OGpos = pContext.getClickedPos();
        Direction direction = pContext.getHorizontalDirection();
        int[][][] multiblockShape = this.getMultiblockShape();
        int maxHeight = this.getMultiblockShape().length;
        int OGx = OGpos.getX();
        int OGy = OGpos.getY();
        int OGz = OGpos.getZ();
        int xOffset = 0;
        int zOffset = 0;
        if (OGpos.getY() + maxHeight >= level.getMaxBuildHeight()) {
            return null;
        }
        for (int y = 0; y < maxHeight; ++y) {
            for (int x = 0; x < multiblockShape[y].length; ++x) {
                for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                    if (multiblockShape[y][x][z] == 0 || level.getBlockState(new BlockPos(OGx + (xOffset = this.getXOffset(direction, x, z)), OGy + y, OGz + (zOffset = this.getZOffset(direction, x, z)))).canBeReplaced()) continue;
                    return null;
                }
            }
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
    }

    protected int getXOffset(Direction facing, int x, int z) {
        int xOffset = 0;
        if (facing.equals((Object)Direction.NORTH)) {
            xOffset = x;
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            xOffset = -x;
        }
        if (facing.equals((Object)Direction.EAST)) {
            xOffset = z;
        }
        if (facing.equals((Object)Direction.WEST)) {
            xOffset = -z;
        }
        return xOffset;
    }

    protected int getZOffset(Direction facing, int x, int z) {
        int zOffset = 0;
        if (facing.equals((Object)Direction.NORTH)) {
            zOffset = -z;
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            zOffset = z;
        }
        if (facing.equals((Object)Direction.EAST)) {
            zOffset = x;
        }
        if (facing.equals((Object)Direction.WEST)) {
            zOffset = -x;
        }
        return zOffset;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockPos state1Pos = null;
        state1Pos = (Integer)pState.getValue((Property)this.getMultiblockPart()) != 1 ? this.findBlockState1(pPos, (LevelAccessor)pLevel) : pPos;
        if (state1Pos != null) {
            if (!this.canSurvive(pLevel.getBlockState(state1Pos), (LevelReader)pLevel, state1Pos)) {
                pLevel.destroyBlock(pPos, true);
            }
        } else {
            pLevel.destroyBlock(pPos, true);
        }
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockPos state1Pos = null;
        state1Pos = (Integer)pState.getValue((Property)this.getMultiblockPart()) != 1 ? this.findBlockState1(pCurrentPos, pLevel) : pCurrentPos;
        if (state1Pos != null) {
            if (!this.canSurvive(pLevel.getBlockState(state1Pos), (LevelReader)pLevel, state1Pos)) {
                pLevel.scheduleTick(pCurrentPos, (Block)this, 0);
            }
        } else {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 0);
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (!pLevel.getBlockState(pPos).is((Block)this)) {
            return true;
        }
        Direction facing = (Direction)pState.getValue((Property)FACING);
        if ((Integer)pState.getValue((Property)this.getMultiblockPart()) != 1) {
            return true;
        }
        int OGx = pPos.getX();
        int OGy = pPos.getY();
        int OGz = pPos.getZ();
        int[][][] multiblockShape = this.getMultiblockShape();
        for (int y = 0; y < multiblockShape.length; ++y) {
            for (int x = 0; x < multiblockShape[y].length; ++x) {
                for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                    int xOffset = this.getXOffset(facing, x, z);
                    int zOffset = this.getZOffset(facing, x, z);
                    int part = 0;
                    BlockState state = pLevel.getBlockState(new BlockPos(OGx + xOffset, OGy + y, OGz + zOffset));
                    if (state.hasProperty((Property)this.getMultiblockPart())) {
                        part = (Integer)state.getValue((Property)this.getMultiblockPart());
                    }
                    if (multiblockShape[y][x][z] == 0 || multiblockShape[y][x][z] == part) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected BlockPos findBlockState1(BlockPos currentPos, LevelAccessor level) {
        if (!level.getBlockState(currentPos).hasProperty((Property)FACING)) {
            return null;
        }
        Direction facing = (Direction)level.getBlockState(currentPos).getValue((Property)FACING);
        int[][][] multiblockShape = this.getMultiblockShape();
        int partNum = (Integer)level.getBlockState(currentPos).getValue((Property)this.getMultiblockPart());
        for (int y = 0; y < multiblockShape.length; ++y) {
            for (int x = 0; x < multiblockShape[y].length; ++x) {
                for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                    if (multiblockShape[y][x][z] != partNum) continue;
                    int xOffset = -this.getXOffset(facing, x, z);
                    int zOffset = -this.getZOffset(facing, x, z);
                    BlockPos possibleState1 = new BlockPos(currentPos.getX() + xOffset, currentPos.getY() - y, currentPos.getZ() + zOffset);
                    if (!level.getBlockState(possibleState1).is(this.asBlock()) || !((Direction)level.getBlockState(possibleState1).getValue((Property)FACING)).equals((Object)facing)) continue;
                    return possibleState1;
                }
            }
        }
        return null;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            Direction direction = (Direction)pState.getValue((Property)FACING);
            int[][][] multiblockShape = this.getMultiblockShape();
            int OGx = pPos.getX();
            int OGy = pPos.getY();
            int OGz = pPos.getZ();
            if ((Integer)pState.getValue((Property)this.getMultiblockPart()) == 1 && !pOldState.is(this.asBlock())) {
                for (int y = 0; y < multiblockShape.length; ++y) {
                    for (int x = 0; x < multiblockShape[y].length; ++x) {
                        for (int z = 0; z < multiblockShape[y][x].length; ++z) {
                            if (x + y + z == 0 || multiblockShape[y][x][z] == 0) continue;
                            int xOffset = this.getXOffset(direction, x, z);
                            int zOffset = this.getZOffset(direction, x, z);
                            pLevel.setBlock(new BlockPos(OGx + xOffset, OGy + y, OGz + zOffset), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getMultiblockPart(), (Comparable)Integer.valueOf(multiblockShape[y][x][z]))).setValue((Property)FACING, (Comparable)direction), 2);
                        }
                    }
                }
            }
        }
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }
}

