/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;
import net.redchujelly.cluttered.entity.ChairEntity;
import net.redchujelly.cluttered.setup.EntityTypeRegistration;

public class MultiblockChair
extends MultiblockPlacer {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    private static final float SEAT_OFFSET = 0.5f;
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {2}}};

    public MultiblockChair(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (!((Boolean)pState.getValue((Property)OCCUPIED)).booleanValue() && !pPlayer.isShiftKeyDown()) {
            if (!pLevel.isClientSide) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)), 2);
                ChairEntity seat = new ChairEntity((EntityType)EntityTypeRegistration.CHAIR_ENTITY.get(), pLevel, pPos);
                seat.setPos((double)pPos.getX() + 0.5, (float)(pPos.getY() - 1) + this.getSeatOffset(), (double)pPos.getZ() + 0.5);
                pLevel.addFreshEntity((Entity)seat);
                pPlayer.startRiding((Entity)seat);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        List chairBlocks = pLevel.getEntitiesOfClass(ChairEntity.class, new AABB(pPos));
        for (ChairEntity chair : chairBlocks) {
            chair.kill();
        }
    }

    public float getSeatOffset() {
        return 0.5f;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OCCUPIED});
    }
}

