/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;

public class MultiblockBedBlock
extends MultiblockPlacer {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)6);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1, 3, 5}, {2, 4, 6}}};

    public MultiblockBedBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, LivingEntity sleeper) {
        return true;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public Direction getBedDirection(BlockState state, LevelReader level, BlockPos pos) {
        return (Direction)state.getValue((Property)FACING);
    }

    public void setBedOccupied(BlockState state, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        level.setBlock(pos, (BlockState)state.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 2);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return InteractionResult.CONSUME;
        }
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        if (!(part != 3 && part != 4 || (pState = pLevel.getBlockState(pPos = pPos.relative((Direction)pState.getValue((Property)FACING)))).is((Block)this))) {
            return InteractionResult.CONSUME;
        }
        if (!(part != 1 && part != 2 || (pState = pLevel.getBlockState(pPos = pPos.relative((Direction)pState.getValue((Property)FACING), 2))).is((Block)this))) {
            return InteractionResult.CONSUME;
        }
        if (!MultiblockBedBlock.canSetSpawn(pLevel)) {
            pLevel.removeBlock(pPos, false);
            BlockPos removePos = pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite());
            if (pLevel.getBlockState(removePos).is((Block)this)) {
                pLevel.removeBlock(removePos, false);
            }
            Vec3 center = pPos.getCenter();
            pLevel.explode(null, pLevel.damageSources().badRespawnPointExplosion(center), null, center, 5.0f, true, Level.ExplosionInteraction.BLOCK);
        } else {
            if (((Boolean)pState.getValue((Property)OCCUPIED)).booleanValue()) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
                return InteractionResult.SUCCESS;
            }
            pPlayer.startSleepInBed(pPos).ifLeft(sleepingProblem -> {
                if (sleepingProblem.getMessage() != null) {
                    pPlayer.displayClientMessage(sleepingProblem.getMessage(), true);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean canSetSpawn(Level pLevel) {
        return pLevel.dimensionType().bedWorks();
    }

    public void fallOn(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        super.fallOn(pLevel, pState, pPos, pEntity, pFallDistance * 0.5f);
    }

    public void updateEntityAfterFallOn(BlockGetter pLevel, Entity pEntity) {
        if (pEntity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(pLevel, pEntity);
        } else {
            this.bounceUp(pEntity);
        }
    }

    private void bounceUp(Entity pEntity) {
        Vec3 $$1 = pEntity.getDeltaMovement();
        if ($$1.y < 0.0) {
            double $$2 = pEntity instanceof LivingEntity ? 1.0 : 0.8;
            pEntity.setDeltaMovement($$1.x, -$$1.y * (double)0.66f * $$2, $$1.z);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OCCUPIED});
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }
}

