/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.redchujelly.cluttered.block.custom.furniture.storage.CardboardBoxBlock;
import net.redchujelly.cluttered.block.entity.CustomStorageBlockEntity;

public class CardboardBoxBlockEntity
extends CustomStorageBlockEntity {
    private final ContainerOpenersCounter openersCounter;

    public CardboardBoxBlockEntity(BlockEntityType<?> pType, final BlockPos pPos, BlockState pBlockState, int rows) {
        super(pType, pPos, pBlockState, rows);
        this.openersCounter = new ContainerOpenersCounter(this){

            protected void onOpen(Level level, BlockPos blockPos, BlockState blockState) {
                level.playSound(null, pPos, SoundEvents.SPORE_BLOSSOM_HIT, SoundSource.BLOCKS);
            }

            protected void onClose(Level level, BlockPos blockPos, BlockState blockState) {
                level.playSound(null, pPos, SoundEvents.SPORE_BLOSSOM_HIT, SoundSource.BLOCKS);
                CardboardBoxBlock.updateOpenState(pPos, level);
            }

            protected void openerCountChanged(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
            }

            protected boolean isOwnContainer(Player player) {
                return false;
            }
        };
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"cluttered.box");
    }

    @Override
    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public boolean containsItems() {
        NonNullList<ItemStack> items = this.getItems();
        for (ItemStack item : items) {
            if (item.getItem().equals(Items.AIR)) continue;
            return true;
        }
        return false;
    }
}

