/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.CardboardBoxState;
import net.redchujelly.cluttered.block.custom.furniture.storage.StorageBlock;
import net.redchujelly.cluttered.block.entity.CardboardBoxBlockEntity;
import net.redchujelly.cluttered.block.entity.CustomStorageBlockEntity;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class CardboardBoxBlock
extends StorageBlock {
    private static final VoxelShape SHAPE_CLOSED_NS = Block.box((double)4.0, (double)0.0, (double)2.5, (double)12.0, (double)7.0, (double)13.5);
    private static final VoxelShape SHAPE_CLOSED_EW = Block.box((double)2.5, (double)0.0, (double)4.0, (double)13.5, (double)7.0, (double)12.0);
    private static final VoxelShape SHAPE_FULL_NS = Block.box((double)4.0, (double)0.0, (double)2.5, (double)12.0, (double)11.0, (double)13.5);
    private static final VoxelShape SHAPE_FULL_EW = Block.box((double)2.5, (double)0.0, (double)4.0, (double)13.5, (double)11.0, (double)12.0);
    public static final EnumProperty<CardboardBoxState> OPEN_STATE = EnumProperty.create((String)"open_state", CardboardBoxState.class);

    public CardboardBoxBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(OPEN_STATE, (Comparable)((Object)CardboardBoxState.EMPTY)));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        if (((CardboardBoxState)((Object)pState.getValue(OPEN_STATE))).equals((Object)CardboardBoxState.FULL)) {
            return facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? SHAPE_FULL_NS : SHAPE_FULL_EW;
        }
        return facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? SHAPE_CLOSED_NS : SHAPE_CLOSED_EW;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.isCrouching()) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof CustomStorageBlockEntity) {
                pPlayer.openMenu((MenuProvider)((CustomStorageBlockEntity)blockEntity));
                return InteractionResult.CONSUME;
            }
        } else {
            if (((CardboardBoxState)((Object)pState.getValue(OPEN_STATE))).equals((Object)CardboardBoxState.CLOSED)) {
                BlockEntity entity = pLevel.getBlockEntity(pPos);
                if (!(entity instanceof CardboardBoxBlockEntity)) {
                    pLevel.removeBlock(pPos, false);
                    return InteractionResult.CONSUME;
                }
                pLevel.setBlock(pPos, (BlockState)pState.setValue(OPEN_STATE, (Comparable)((Object)(((CardboardBoxBlockEntity)entity).containsItems() ? CardboardBoxState.FULL : CardboardBoxState.EMPTY))), 2);
            } else {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(OPEN_STATE, (Comparable)((Object)CardboardBoxState.CLOSED)), 2);
            }
            pLevel.playSound(null, pPos, SoundEvents.CAVE_VINES_BREAK, SoundSource.BLOCKS);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OPEN_STATE});
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)TileEntityRegistration.CARDBOARD_BOX_BE.get()).create(blockPos, blockState);
    }

    public static void updateOpenState(BlockPos pos, Level level) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof CardboardBoxBlock) {
            level.setBlock(pos, (BlockState)state.setValue(OPEN_STATE, (Comparable)((Object)CardboardBoxBlock.getOpenState(pos, level))), 2);
        }
    }

    private static CardboardBoxState getOpenState(BlockPos pos, Level level) {
        BlockState stateAtPos = level.getBlockState(pos);
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof CardboardBoxBlockEntity && stateAtPos.hasProperty(OPEN_STATE)) {
            if (((CardboardBoxState)((Object)stateAtPos.getValue(OPEN_STATE))).equals((Object)CardboardBoxState.CLOSED)) {
                return CardboardBoxState.CLOSED;
            }
            if (((CardboardBoxBlockEntity)entity).containsItems()) {
                return CardboardBoxState.FULL;
            }
        }
        return CardboardBoxState.EMPTY;
    }
}

