/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.storage.StorageBlock;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class BriefcaseBlock
extends StorageBlock {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)1.0, (double)0.0, (double)6.0, (double)15.0, (double)11.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)11.0, (double)10.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)2.0, (double)0.0, (double)1.0, (double)10.0, (double)11.0, (double)15.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)6.0, (double)0.0, (double)1.0, (double)14.0, (double)11.0, (double)15.0);

    public BriefcaseBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)TileEntityRegistration.THREE_ROWS_BE.get()).create(blockPos, blockState);
    }
}

