/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class TarrytownStoveBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)13.0, (double)12.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)13.0, (double)14.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)4.0, (double)0.0, (double)0.0, (double)14.0, (double)13.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)2.0, (double)0.0, (double)0.0, (double)12.0, (double)13.0, (double)16.0);
    private static final Vec3 PARTICLE_OFFSET_N = new Vec3(0.6875, 1.0625, 0.4375);
    private static final Vec3 PARTICLE_OFFSET_S = new Vec3(0.25, 1.0625, 0.5625);
    private static final Vec3 PARTICLE_OFFSET_E = new Vec3(0.5625, 1.0625, 0.6875);
    private static final Vec3 PARTICLE_OFFSET_W = new Vec3(0.4375, 1.0625, 0.25);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public TarrytownStoveBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && stack.getItem() instanceof FlintAndSteelItem) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
                level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS);
                if (stack.isDamageableItem()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
                level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{LIT});
    }

    private Vec3 getOffset(BlockState state) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> PARTICLE_OFFSET_S;
            case Direction.EAST -> PARTICLE_OFFSET_E;
            case Direction.WEST -> PARTICLE_OFFSET_W;
            default -> PARTICLE_OFFSET_N;
        };
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            double $$4 = (double)pPos.getX() + 0.5;
            double $$5 = pPos.getY();
            double $$6 = (double)pPos.getZ() + 0.5;
            if (pRandom.nextDouble() < 0.1) {
                pLevel.playLocalSound($$4, $$5, $$6, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction $$7 = (Direction)pState.getValue((Property)FACING);
            Direction.Axis $$8 = $$7.getAxis();
            double $$10 = pRandom.nextDouble() * 0.45 - 0.3;
            double $$11 = $$8 == Direction.Axis.X ? (double)$$7.getStepX() * 0.37 : $$10;
            double $$12 = pRandom.nextDouble() * 8.0 / 16.0;
            double $$13 = $$8 == Direction.Axis.Z ? (double)$$7.getStepZ() * 0.37 : $$10;
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, $$4 + $$11, $$5 + $$12, $$6 + $$13, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypes.FLAME, $$4 + $$11, $$5 + $$12, $$6 + $$13, 0.0, 0.0, 0.0);
            if (pRandom.nextDouble() < 0.2) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, $$4 + this.getOffset((BlockState)pState).x - 0.5, $$5 + this.getOffset((BlockState)pState).y, $$6 + this.getOffset((BlockState)pState).z - 0.5, 0.0, (double)0.03f, 0.0);
            }
        }
    }
}

