/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class KitchenSinkBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);

    public KitchenSinkBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.BUCKET) || stack.is(Items.GLASS_BOTTLE)) {
            if (!level.isClientSide) {
                SoundEvent sound;
                ItemStack filledItem;
                if (stack.is(Items.GLASS_BOTTLE)) {
                    ItemStack i = new ItemStack((ItemLike)Items.POTION);
                    i.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
                    filledItem = i;
                    sound = SoundEvents.BOTTLE_FILL;
                } else {
                    filledItem = new ItemStack((ItemLike)Items.WATER_BUCKET);
                    sound = SoundEvents.BUCKET_FILL;
                }
                if (stack.getCount() == 1) {
                    player.setItemInHand(hand, filledItem);
                } else if (player.addItem(filledItem)) {
                    stack.shrink(1);
                } else {
                    player.drop(filledItem, true);
                    stack.shrink(1);
                }
                level.playSound(null, pos, sound, SoundSource.BLOCKS);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }
}

