/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class EyeBlock
extends Block {
    public static final BooleanProperty LOOKING_LEFT = BooleanProperty.create((String)"looking_left");
    public static final IntegerProperty BLINK_FRAME = IntegerProperty.create((String)"frame", (int)0, (int)5);

    public EyeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LOOKING_LEFT, (Comparable)Boolean.valueOf(true))).setValue((Property)BLINK_FRAME, (Comparable)Integer.valueOf(0)));
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)BLINK_FRAME) == 0;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pState.hasProperty((Property)BLINK_FRAME)) {
            int frame = (Integer)pState.getValue((Property)BLINK_FRAME);
            if (frame < 5) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BLINK_FRAME, (Comparable)Integer.valueOf(frame + 1)), 2);
                pLevel.scheduleTick(pPos, (Block)this, 4);
            }
            if (frame == 5) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BLINK_FRAME, (Comparable)Integer.valueOf(0)), 2);
            }
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isClientSide) {
            float random = pRandom.nextFloat();
            if ((double)random < 0.08) {
                pLevel.scheduleTick(pPos, (Block)this, 0);
                pLevel.playSound(null, pPos, SoundEvents.FROGSPAWN_BREAK, SoundSource.BLOCKS);
            } else if ((double)random < 0.5) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LOOKING_LEFT, (Comparable)Boolean.valueOf((Boolean)pState.getValue((Property)LOOKING_LEFT) == false)), 2);
                pLevel.playSound(null, pPos, SoundEvents.FROGSPAWNSTEP, SoundSource.BLOCKS);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{LOOKING_LEFT}).add(new Property[]{BLINK_FRAME});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"cluttered.eye_block.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

