/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.redchujelly.cluttered.client.ChairEntityRenderer;
import net.redchujelly.cluttered.config.ClutteredCommonConfigs;
import net.redchujelly.cluttered.datagen.DataGeneration;
import net.redchujelly.cluttered.setup.BlockRegistration;
import net.redchujelly.cluttered.setup.ClutteredLootModifiers;
import net.redchujelly.cluttered.setup.CreativeTabRegistration;
import net.redchujelly.cluttered.setup.EntityTypeRegistration;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;
import net.redchujelly.cluttered.setup.ItemRegistration;
import net.redchujelly.cluttered.setup.SoundRegistration;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import net.redchujelly.cluttered.setup.TreeDecoratorTypeRegistration;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;
import net.redchujelly.cluttered.util.ClutteredWoodTypes;
import org.slf4j.Logger;

@Mod(value="cluttered")
public class Cluttered {
    public static final String MODID = "cluttered";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Cluttered(IEventBus modEventBus, ModContainer modContainer) {
        ClutteredLootModifiers.register(modEventBus);
        EntityTypeRegistration.register(modEventBus);
        SoundRegistration.register(modEventBus);
        BlockRegistration.register(modEventBus);
        ItemRegistration.register(modEventBus);
        TileEntityRegistration.register(modEventBus);
        CreativeTabRegistration.register(modEventBus);
        TrunkPlacerTypeRegistration.register(modEventBus);
        FoliagePlacerTypeRegistration.register(modEventBus);
        TreeDecoratorTypeRegistration.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ClutteredCommonConfigs.SPEC, "cluttered-common.toml");
        modEventBus.addListener(DataGeneration::generate);
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.WILLOW_LEAVES.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.FLOWERING_CARPET_WILLOW.get()).asItem(), 0.075f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.WILLOW_SAPLING.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.WILLOW_VINES.get()).asItem(), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.POPLAR_LEAVES.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.FLOWERING_CARPET_POPLAR.get()).asItem(), 0.075f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.FLOWERING_POPLAR_LEAVES.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.POPLAR_SAPLING.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.CRABAPPLE_LEAVES.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.FLOWERING_CARPET_CRABAPPLE.get()).asItem(), 0.075f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.CRABAPPLE_SAPLING.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.SYCAMORE_LEAVES.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.SYCAMORE_SAPLING.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.MAPLE_LEAVES_FLOWERING.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.MAPLE_LEAVES.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.MAPLE_SAPLING.get()).asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.BLUE_MUSHROOM_SAPLING.get()).asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((Block)BlockRegistration.RED_MUSHROOM_SAPLING.get()).asItem(), 0.65f);
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistration.WILLOW_SAPLING.getId(), BlockRegistration.POTTED_WILLOW_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistration.POPLAR_SAPLING.getId(), BlockRegistration.POTTED_POPLAR_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistration.CRABAPPLE_SAPLING.getId(), BlockRegistration.POTTED_CRABAPPLE_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistration.SYCAMORE_SAPLING.getId(), BlockRegistration.POTTED_SYCAMORE_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistration.MAPLE_SAPLING.getId(), BlockRegistration.POTTED_MAPLE_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistration.BLUE_MUSHROOM_SAPLING.getId(), BlockRegistration.POTTED_BLUE_MUSHROOM_SAPLING);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistration.RED_MUSHROOM_SAPLING.getId(), BlockRegistration.POTTED_RED_MUSHROOM_SAPLING);
        });
    }

    @EventBusSubscriber(modid="cluttered", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.WILLOW);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.FLOWERING_WILLOW);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.POPLAR);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.FLOWERING_POPLAR);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.CRABAPPLE);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.FLOWERING_CRABAPPLE);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.SYCAMORE);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.MAPLE);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.RED_MUSHROOM);
                Sheets.addWoodType((WoodType)ClutteredWoodTypes.BLUE_MUSHROOM);
            });
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EntityTypeRegistration.CHAIR_ENTITY.get(), ChairEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)TileEntityRegistration.CLUTTERED_SIGN_BE.get(), SignRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)TileEntityRegistration.CLUTTERED_HANGING_SIGN_BE.get(), HangingSignRenderer::new);
        }
    }
}

